// Title: Statistique de test combinant C et S dans notre second article (2016) avec Alain ... (avant c'était dl5 dans Pkurtosis_16oct2009.pdf)
// Ref. (book or article): 

#include <R.h>
#include "Rmath.h"

extern "C" {

  /*
  typedef double optimfn(int n, double *par, void *ex);
  typedef void optimgr(int n, double *par, double *gr, void *ex);
  void lbfgsb(int n, int lmm, double *x, double *lower,
	      double *upper, int *nbd, double *Fmin, optimfn fn,
	      optimgr gr, int *fail, void *ex, double factr,
	      double pgtol, int *fncount, int *grcount,
	      int maxit, char *msg, int trace, int nREPORT);

  void myoptimgrCS(int n, double *par, double *gr, void *ex) {
    double quantileestimCS(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimCS(1, parh, ex) - quantileestimCS(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }

  double quantileestimCS(int n, double *par, void *ex) {
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{-0.0118,-4.3150,-5.3940,-6.7243,-5.2441,-2.4318,-0.6308,-0.0846,-0.0046},
			    {-0.0136,-4.2761,-5.1780,-6.5204,-5.1558,-2.4253,-0.6371,-0.0865,-0.0047},
			    {-0.0143,-4.2321,-4.9162,-6.1457,-4.8417,-2.2753,-0.5966,-0.0808,-0.0044},
			    {-0.0147,-4.1866,-4.6510,-5.7483,-4.4958,-2.1015,-0.5468,-0.0733,-0.0039},
			    {-0.0157,-4.1711,-4.5349,-5.6277,-4.4093,-2.0612,-0.5354,-0.0716,-0.0038},
			    {-0.0157,-4.1368,-4.3521,-5.3914,-4.2323,-1.9872,-0.5188,-0.0698,-0.0038},
			    {-0.0148,-4.0914,-4.0937,-4.9674,-3.8416,-1.7850,-0.4604,-0.0610,-0.0032},
			    {-0.0148,-4.0596,-3.8775,-4.5754,-3.4521,-1.5735,-0.3979,-0.0516,-0.0027},
			    {-0.0159,-4.0599,-3.8679,-4.6562,-3.5715,-1.6465,-0.4202,-0.0549,-0.0029},
			    {-0.0153,-4.0327,-3.6889,-4.3367,-3.2546,-1.4757,-0.3710,-0.0478,-0.0025},
			    {-0.0157,-4.0177,-3.6237,-4.3247,-3.3064,-1.5275,-0.3916,-0.0516,-0.0027},
			    {-0.0163,-4.0226,-3.6023,-4.3041,-3.2924,-1.5254,-0.3933,-0.0522,-0.0028},
			    {-0.0153,-3.9879,-3.4242,-4.0024,-2.9956,-1.3599,-0.3424,-0.0442,-0.0023},
			    {-0.0162,-3.9865,-3.4000,-4.0092,-3.0190,-1.3750,-0.3470,-0.0449,-0.0023},
			    {-0.0153,-3.9542,-3.2072,-3.6283,-2.6208,-1.1528,-0.2808,-0.0349,-0.0017},
			    {-0.0156,-3.9476,-3.1630,-3.5982,-2.6167,-1.1586,-0.2841,-0.0356,-0.0018},
			    {-0.0153,-3.9327,-3.0842,-3.4920,-2.5331,-1.1206,-0.2746,-0.0344,-0.0017},
			    {-0.0158,-3.9354,-3.0793,-3.5166,-2.5647,-1.1405,-0.2820,-0.0358,-0.0018},
			    {-0.0159,-3.9259,-3.0314,-3.4721,-2.5450,-1.1391,-0.2838,-0.0364,-0.0019},
			    {-0.0157,-3.9150,-2.9545,-3.3505,-2.4364,-1.0844,-0.2686,-0.0342,-0.0018},
			    {-0.0151,-3.8952,-2.8320,-3.0969,-2.1612,-0.9262,-0.2203,-0.0268,-0.0013},
			    {-0.0148,-3.8776,-2.7496,-2.9930,-2.0870,-0.8957,-0.2132,-0.0260,-0.0013},
			    {-0.0147,-3.8808,-2.7476,-3.0150,-2.1217,-0.9207,-0.2226,-0.0277,-0.0014},
			    {-0.0148,-3.8751,-2.7314,-3.0237,-2.1396,-0.9298,-0.2246,-0.0278,-0.0014},
			    {-0.0140,-3.8425,-2.5288,-2.6224,-1.7390,-0.7144,-0.1616,-0.0184,-0.0008},
			    {-0.0152,-3.8689,-2.6821,-2.9737,-2.1055,-0.9168,-0.2228,-0.0279,-0.0014},
			    {-0.0147,-3.8499,-2.5367,-2.6717,-1.7884,-0.7379,-0.1680,-0.0194,-0.0009},
			    {-0.0150,-3.8583,-2.5841,-2.7966,-1.9201,-0.8098,-0.1895,-0.0227,-0.0011},
			    {-0.0143,-3.8310,-2.4276,-2.4869,-1.6094,-0.6414,-0.1398,-0.0151,-0.0006},
			    {-0.0139,-3.8187,-2.3464,-2.3550,-1.5009,-0.5942,-0.1289,-0.0139,-0.0006},
			    {-0.0145,-3.8271,-2.3962,-2.4754,-1.6207,-0.6573,-0.1476,-0.0168,-0.0008},
			    {-0.0143,-3.8218,-2.3608,-2.4125,-1.5559,-0.6211,-0.1368,-0.0152,-0.0007},
			    {-0.0140,-3.8149,-2.3413,-2.4160,-1.5787,-0.6400,-0.1440,-0.0164,-0.0007},
			    {-0.0145,-3.8203,-2.3398,-2.3999,-1.5505,-0.6208,-0.1379,-0.0156,-0.0007},
			    {-0.0140,-3.8044,-2.2458,-2.2156,-1.3607,-0.5159,-0.1069,-0.0109,-0.0004},
			    {-0.0146,-3.8201,-2.3352,-2.4563,-1.6362,-0.6725,-0.1533,-0.0178,-0.0008},
			    {-0.0135,-3.7924,-2.1885,-2.1587,-1.3308,-0.5063,-0.1050,-0.0107,-0.0004},
			    {-0.0139,-3.7999,-2.2145,-2.2134,-1.3872,-0.5379,-0.1147,-0.0122,-0.0005},
			    {-0.0143,-3.8085,-2.2534,-2.3076,-1.4707,-0.5730,-0.1219,-0.0128,-0.0005},
			    {-0.0143,-3.8041,-2.2281,-2.2896,-1.4886,-0.6043,-0.1379,-0.0163,-0.0008},
			    {-0.0139,-3.7904,-2.1516,-2.1369,-1.3302,-0.5149,-0.1103,-0.0119,-0.0005},
			    {-0.0141,-3.7854,-2.0987,-2.0824,-1.2846,-0.4917,-0.1046,-0.0113,-0.0005},
			    {-0.0145,-3.7892,-2.1013,-2.1475,-1.3773,-0.5529,-0.1259,-0.0150,-0.0007},
			    {-0.0138,-3.7684,-1.9895,-1.9797,-1.2199,-0.4652,-0.0986,-0.0106,-0.0004},
			    {-0.0140,-3.7618,-1.9313,-1.8868,-1.1338,-0.4221,-0.0876,-0.0092,-0.0004},
			    {-0.0137,-3.7492,-1.8735,-1.8422,-1.1308,-0.4386,-0.0976,-0.0115,-0.0006},
			    {-0.0136,-3.7416,-1.8062,-1.7146,-0.9971,-0.3623,-0.0743,-0.0079,-0.0003},
			    {-0.0134,-3.7362,-1.7583,-1.6347,-0.9128,-0.3112,-0.0574,-0.0050,-0.0001},
			    {-0.0136,-3.7409,-1.7934,-1.7498,-1.0466,-0.3899,-0.0827,-0.0092,-0.0004},
			    {-0.0138,-3.7423,-1.7731,-1.7164,-1.0154,-0.3736,-0.0781,-0.0085,-0.0004},
			    {-0.0137,-3.7376,-1.7481,-1.6955,-1.0064,-0.3733,-0.0795,-0.0090,-0.0004},
			    {-0.0139,-3.7404,-1.7388,-1.6992,-1.0120,-0.3755,-0.0800,-0.0090,-0.0004},
			    {-0.0137,-3.7298,-1.6993,-1.6993,-1.0549,-0.4135,-0.0945,-0.0116,-0.0006},
			    {-0.0134,-3.7223,-1.6257,-1.5454,-0.8939,-0.3251,-0.0691,-0.0080,-0.0004},
			    {-0.0137,-3.7238,-1.6183,-1.5246,-0.8506,-0.2884,-0.0547,-0.0053,-0.0002},
			    {-0.0140,-3.7287,-1.6517,-1.6609,-1.0364,-0.4099,-0.0958,-0.0121,-0.0006},
			    {-0.0139,-3.7295,-1.6547,-1.6688,-1.0304,-0.3986,-0.0904,-0.0110,-0.0006},
			    {-0.0140,-3.7274,-1.6357,-1.6550,-1.0346,-0.4093,-0.0960,-0.0122,-0.0007},
			    {-0.0135,-3.7196,-1.5794,-1.5582,-0.9496,-0.3682,-0.0853,-0.0108,-0.0006},
			    {-0.0137,-3.7146,-1.5494,-1.4941,-0.8688,-0.3136,-0.0658,-0.0074,-0.0003},
			    {-0.0134,-3.7052,-1.5012,-1.4181,-0.8088,-0.2898,-0.0613,-0.0071,-0.0003},
			    {-0.0141,-3.7231,-1.5887,-1.6198,-1.0054,-0.3888,-0.0887,-0.0110,-0.0006},
			    {-0.0136,-3.7095,-1.5099,-1.4933,-0.8985,-0.3392,-0.0761,-0.0093,-0.0005},
			    {-0.0140,-3.7251,-1.5450,-1.5434,-0.9362,-0.3551,-0.0799,-0.0097,-0.0005},
			    {-0.0141,-3.7300,-1.5888,-1.6524,-1.0417,-0.4065,-0.0935,-0.0116,-0.0006},
			    {-0.0135,-3.7090,-1.4736,-1.4447,-0.8602,-0.3225,-0.0726,-0.0090,-0.0005},
			    {-0.0140,-3.7172,-1.5222,-1.5638,-0.9915,-0.3966,-0.0948,-0.0123,-0.0007},
			    {-0.0140,-3.7088,-1.4846,-1.5032,-0.9371,-0.3707,-0.0887,-0.0117,-0.0006},
			    {-0.0138,-3.7120,-1.4605,-1.4187,-0.8199,-0.2917,-0.0612,-0.0070,-0.0003},
			    {-0.0140,-3.7172,-1.5012,-1.5266,-0.9444,-0.3656,-0.0845,-0.0107,-0.0006},
			    {-0.0138,-3.7102,-1.4637,-1.4708,-0.9047,-0.3513,-0.0821,-0.0105,-0.0006},
			    {-0.0141,-3.7158,-1.4869,-1.5141,-0.9412,-0.3671,-0.0857,-0.0109,-0.0006},
			    {-0.0139,-3.7096,-1.4292,-1.3606,-0.7566,-0.2551,-0.0503,-0.0053,-0.0002},
			    {-0.0134,-3.6950,-1.3502,-1.2473,-0.6716,-0.2182,-0.0410,-0.0041,-0.0002},
			    {-0.0143,-3.7276,-1.5276,-1.6336,-1.0810,-0.4498,-0.1120,-0.0151,-0.0008},
			    {-0.0139,-3.7099,-1.4419,-1.4602,-0.9000,-0.3497,-0.0825,-0.0107,-0.0006},
			    {-0.0140,-3.7138,-1.4484,-1.4847,-0.9245,-0.3586,-0.0833,-0.0106,-0.0006},
			    {-0.0136,-3.7095,-1.4408,-1.4739,-0.9093,-0.3480,-0.0796,-0.0099,-0.0005},
			    {-0.0135,-3.7063,-1.4005,-1.4028,-0.8446,-0.3145,-0.0700,-0.0085,-0.0004},
			    {-0.0139,-3.7044,-1.3991,-1.4171,-0.8730,-0.3369,-0.0784,-0.0100,-0.0005},
			    {-0.0139,-3.7082,-1.4286,-1.4716,-0.9110,-0.3478,-0.0790,-0.0098,-0.0005},
			    {-0.0140,-3.7126,-1.4310,-1.4707,-0.9106,-0.3498,-0.0807,-0.0102,-0.0005},
			    {-0.0141,-3.7117,-1.4262,-1.4800,-0.9377,-0.3710,-0.0881,-0.0114,-0.0006},
			    {-0.0137,-3.7058,-1.3886,-1.4038,-0.8610,-0.3290,-0.0758,-0.0096,-0.0005},
			    {-0.0139,-3.7041,-1.3835,-1.3911,-0.8446,-0.3198,-0.0733,-0.0092,-0.0005},
			    {-0.0141,-3.7093,-1.4298,-1.5014,-0.9589,-0.3789,-0.0890,-0.0113,-0.0006},
			    {-0.0139,-3.7184,-1.4514,-1.5121,-0.9503,-0.3692,-0.0858,-0.0109,-0.0006},
			    {-0.0142,-3.7188,-1.4536,-1.5327,-0.9880,-0.3964,-0.0951,-0.0123,-0.0007},
			    {-0.0133,-3.6970,-1.3511,-1.3236,-0.7687,-0.2731,-0.0578,-0.0067,-0.0003},
			    {-0.0142,-3.7153,-1.4409,-1.5079,-0.9557,-0.3753,-0.0882,-0.0113,-0.0006},
			    {-0.0144,-3.7233,-1.4839,-1.5850,-1.0198,-0.4021,-0.0937,-0.0117,-0.0006},
			    {-0.0137,-3.7024,-1.3709,-1.3765,-0.8387,-0.3197,-0.0737,-0.0093,-0.0005},
			    {-0.0140,-3.7032,-1.3735,-1.3601,-0.8042,-0.2938,-0.0646,-0.0078,-0.0004},
			    {-0.0141,-3.7085,-1.3910,-1.4013,-0.8514,-0.3207,-0.0723,-0.0089,-0.0005},
			    {-0.0140,-3.7007,-1.3524,-1.3389,-0.7969,-0.2934,-0.0648,-0.0078,-0.0004},
			    {-0.0139,-3.7090,-1.4062,-1.4469,-0.8949,-0.3400,-0.0768,-0.0094,-0.0005},
			    {-0.0138,-3.7020,-1.3637,-1.3567,-0.8116,-0.3014,-0.0675,-0.0083,-0.0004},
			    {-0.0140,-3.7135,-1.4057,-1.4353,-0.8847,-0.3377,-0.0773,-0.0097,-0.0005},
			    {-0.0135,-3.7069,-1.4189,-1.5045,-0.9740,-0.3907,-0.0935,-0.0121,-0.0007},
			    {-0.0135,-3.7018,-1.3493,-1.3117,-0.7539,-0.2657,-0.0561,-0.0065,-0.0003}};

    
    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }
    
    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(log(tanh(R_pow(fabs(log(par[0])), 0.6603961))), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(log(tanh(R_pow(fabs(log(par[0])), 0.6603961))), i - 1);
    }

    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);

    return res;
  }

*/

  void stat39(double *x, int *xlen, double *level, int *nblevel, char **name, int *getname, double *statistic, int *pvalcomp, double *pvalue, double *critvalL, double *critvalR, int *usecrit, int *alter, int *decision, double *paramstat, int *nbparamstat) {

// If the test statistic can only be in category 3 or 4 (see just below), INDICATE the following line accordingly. Else, leave it commented.
// 0: two.sided=bilateral, 1: less=unilateral, 2: greater=unilateral, 3: bilateral test that rejects H0 only for large values of the test statistic, 
// 4: bilateral test that rejects H0 only for small values of the test statistic
    alter[0] = 3;    

    int i, j=0, n=xlen[0];
    if (getname[0] == 1) {    
// Here, INDICATE the name of your statistic
      const char *nom = "$X_{APD}$";
// Here, INDICATE the number of parameters of your statistic
      nbparamstat[0] = 0;
// Here, INDICATE the default values of the parameters:
      if (name[0][0] == '1') { // To prevent writing in a non declared address (because maybe paramstat has not be initialized with a sufficient length since the correct value of nbparamstat[0] may be unkown yet).

     }
// The following 7 lines should NOT be modified
      const char *space = " ";
      while (nom[j] != '\0') {
	name[j][0] = nom[j];
	j++;
      }
      for (i=j;i<50;i++) name[i][0] = space[0];
      return;
    }

    if (n>3) {
// Computation of the value of the test statistic
    double qchisq(double p, double df, int lower_tail, int log_p);
    double pchisq(double q, double df, int lower_tail, int log_p);
    double *zchap, C = 0.0, S = 0.0, tmp = 0.0;
    zchap = new double[n];
    double gamma = 0.577215664901533, muchap = 0.0, sigchap, sigchap2 = 0.0, statvalue;

    for (i = 0; i <= (n - 1); i++) muchap = muchap + x[i];
    muchap = muchap / (double)n;

    for (i = 1; i <= n; i++) sigchap2 = sigchap2 + R_pow(x[i - 1] - muchap, 2.0);
    sigchap2 = sigchap2 / (double)n;
    sigchap = sqrt(sigchap2);
    for (i = 0; i <= (n - 1); i++) zchap[i] = (x[i] - muchap) / sigchap;

    
    for (i = 0; i <= (n - 1); i++) {
      if (zchap[i] != 0) {
	tmp = R_pow(zchap[i], 2.0);
	C = C + tmp * log(tmp);
	S = S + zchap[i] * fabs(zchap[i]);
      }
    }

    C = C / (double)n; // This is 2K_2
    S = S / (double)n; // This is S_2

    double kurtcond = R_pow(C - 2 * R_pow(S, 2.0), 1.0 / 3.0);
    double skewtrans = S / sqrt((3.0 - 8.0 / M_PI) * (1.0 - 1.9 / ((double)n)) / ((double)n));
    double espku = R_pow(2.0 - log(2.0) - gamma, 1.0 / 3.0) * (1.0 - 1.026 / ((double)n));
    double varku = ((3.0 * M_PI * M_PI / 2.0 - 14.0) / R_pow(3.0 * R_pow(2.0 - log(2.0) - gamma, 2.0 / 3.0) , 2.0)) * (1.0 - 2.25 / R_pow((double)n, 0.8)) / ((double)n);
    double kurtcondtrans = (kurtcond - espku) / sqrt(varku);
														      
    statvalue = R_pow(skewtrans, 2.0) + R_pow(kurtcondtrans, 2.0);

    //    statvalue = ((double)n) * (R_pow(C - (2.0 - log(2.0) - gamma), 2.0) / (1.5 * M_PI * M_PI - 14.0) + S * S / (3.0 - 8.0 / M_PI));

    statistic[0] = statvalue; // Here is the test statistic value

    if (pvalcomp[0] == 1) {
      // If possible, computation of the p-value.
      #include "pvalues/pvalue39.cpp"
    }

// We take the decision to reject or not to reject the null hypothesis H0
    for (i = 0; i < nblevel[0]; i++) {
      
	if (usecrit[0] == 1) { // We use the provided critical values
	  if (statistic[0] > critvalR[i]) decision[i] = 1; else decision[i] = 0; // two.sided (but in this case only one possible critical value)
      } else {
		if (pvalue[0] < level[i]) decision[i] = 1; else decision[i] = 0; // We use the p-value
      }
    }
    
// If applicable, we free the unused array of pointers
    delete[] zchap;

}

// We return
    return;
    
        
  }
 
 
}

