% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindSubstr.R
\name{FindSubstr}
\alias{FindSubstr}
\title{Check for forbidden split results in trees}
\usage{
FindSubstr(ct, ctestv)
}
\arguments{
\item{ct}{Tree to be checked}

\item{ctestv}{Vector with character strings of excluded split results}
}
\value{
\describe{ 
\item{testt}{TRUE if any of the split results in 'ctestv' appears in 'ct'; FALSE otherwise}
}
}
\description{
Check whether one of the character strings in the vector 'ctestv' appears as a split result in the conditional inference tree 'ct';
ctestv is a vector of character strings of forbidden split results.\cr
    Example: ctestv <- rbind('variable1 == \{value1, value2\}','variable2 <= value3'), where
    character strings specified in 'value1', 'value2' are not allowed as results of a splitting operation in 'variable 1' in a tree.
    For restrictions of the type 'variable <= xxx', all split results in a tree are excluded with 'variable <= yyy' and yyy <= xxx.\cr
    Trees with split results specified in 'ctestv' are not accepted during optimization.\cr
    A concrete example is: 'ctestv <- rbind('ETH == \{C2a, C1a\}','AGE <= 20')' for variables 'ETH' and 'AGE' and values 'C2a','C1a', and '20';\cr
    For an application, please refer to, e.g., the functions \code{\link{PrInDT}} and \code{\link{PrInDTreg}}.\cr
    If no restrictions exist, the default = NA is used.
}
