% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C2SPrInDT.R
\name{C2SPrInDT}
\alias{C2SPrInDT}
\title{Two-stage estimation for classification}
\usage{
C2SPrInDT(datain,ctestv=NA,conf.level=0.95,percl,percs,N=99,indind=NA,inddep,
                                 minsplit=NA,minbucket=NA)
}
\arguments{
\item{datain}{Input data frame with class factor variables and the influential variables,\cr
which need to be factors or numericals (transform logicals and character variables to factors)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
Example: ctestv <- rbind('variable1 == \{value1, value2\}','variable2 <= value3'), where
character strings specified in 'value1', 'value2' are not allowed as results of a splitting operation in variable 1 in a tree.\cr
For restrictions of the type 'variable <= xxx', all split results in a tree are excluded with 'variable <= yyy' and yyy <= xxx.\cr
Trees with split results specified in 'ctestv' are not accepted during optimization.\cr
A concrete example is: 'ctestv <- rbind('ETH == \{C2a, C1a\}','AGE <= 20')' for variables 'ETH' and 'AGE' and values 'C2a','C1a', and '20';\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{percl}{list of undersampling percentages of larger class (numerical, > 0 and <= 1): one per dependent class variable in the same order as in 'inddep'}

\item{percs}{list of undersampling percentage of smaller class (numerical, > 0 and <= 1); one per dependent class variable in the same order as in 'inddep'}

\item{N}{no. of repetitions (integer > 0); default = 99}

\item{indind}{indices of independent variables at stage 1; default = NA (means all independent variables used)}

\item{inddep}{indices of dependent variables}

\item{minsplit}{Minimum number of elements in a node to be splitted; default = 20}

\item{minbucket}{Minimum number of elements in a node; default = 7}
}
\value{
\describe{
  \item{models1}{Best trees at stage 1} 
  \item{models2}{Best trees at stage 2} 
  \item{classnames}{names of classification variables}
  \item{baAll}{balanced accuracies of best trees at both stages} 
}
}
\description{
The function C2SPrInDT applies two-stage estimation for finding an optimal model for relationships between the two-class factor variables
specified as column indices of 'datain' in the vector 'inddep' and all other factor and numerical variables in the data frame 'datain' by means of
'N' repetitions of random subsampling with percentages 'percl' for the large classes and 'percs' for the small classes. One percentage of observations 
for each dependent variable has to be specified for the larger and the smaller class. For example, for three dependent variables, 'percl' consists of 
three percentages specified in the order in which the dependent variables appear in 'inddep'.\cr
The dependent variables have to be specified as dummies, i.e. as 0 for 'property absent' or 1 for 'property present' for a certain property the dependent variable is representing.\cr
The indices of the predictors relevant at 1st stage modeling can be specified in the vector 'indind'. If 'indind' is not specied, then all variables in 'datain' 
which are not specified in 'inddep' are used as predictors at 1st stage. At 2nd stage, all such variables are used as predictors anyway.\cr
The optimization citerion is the balanced accuracy on the full sample. The trees generated from undersampling can be restricted by not accepting trees 
including split results specified in the character strings of the vector 'ctestv'. \cr
The parameters 'conf.level', 'minsplit', and 'minbucket' can be used to control the size of the trees.\cr
}
\details{
See Buschfeld & Weihs (2025), Optimizing decision trees for the analysis of World Englishes and sociolinguistic data. Cambridge University Press, section 4.5.6.1, for further information.

Standard output can be produced by means of \code{print(name)} or just \code{name} as well as \code{plot(name)} where 'name' is the output data 
frame of the function.\cr
}
\examples{
data <- PrInDT::data_land # load data
dataclean <- data[,c(1:7,23:24,11:13,22,8:10)]  # only relevant features
indind <- c(1:9) # original predictors
inddep <- c(14:16) # dependent variables
dataland <- na.omit(dataclean)
ctestv <- NA
perc <- c(0.45,0.05,0.25)   # percentages of observations of larger class, 
# 1 per dependent class variable
perc2 <- c(0.75,0.95,0.75)  # percentages of observations of smaller class, 
# 1 per dependent class variable
outland <- C2SPrInDT(dataland,percl=perc,percs=perc2,N=19,indind=indind,inddep=inddep)
outland
plot(outland)

}
