% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getROC.R
\name{getROC}
\alias{getROC}
\title{getROC}
\usage{
getROC(drug.el, p0, gamma = 0.7, filename = "ROC.pdf")
}
\arguments{
\item{drug.el}{A edge list of drugs, which is a two-column matrix, each row defines one edge. Numbers in the edge list represent NSC-ID of drugs.}

\item{p0}{A vector of approved drugs' NSC-ID of interested cancer.}

\item{gamma}{gamma=0.7(default). A probability of losing when doing Random Walk. On the contray, there is a probability of 1-gamma left to itself. The range of this value is (0, 1).}

\item{filename}{filename = "ROC.pdf"(default). File name and path where to save the PDF. Filetype is decided by the extension in the path. Currently only .pdf formats are supported.}
}
\value{
ROC
}
\description{
This function is used to plot ROC.
}
\examples{
e <- getData("drug.edgelist")
brc <- getData("breast_cancer")
\donttest{getROC(e, brc)}
}
