% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopState}
\alias{loopState}
\alias{loopState,PTSample-method}
\title{Get PTSample loop state}
\usage{
\S4method{loopState}{PTSample}(sample)
}
\arguments{
\item{sample}{A \code{\link{PTSample}} object for which the loop state needs
to be determined.}
}
\value{
Returns a \code{logical} value indicating whether a loop is (\code{TRUE})
or isn't (\code{FALSE}) specified for the \code{sample}.
}
\description{
Determines whether a loop is specified for a \code{\link{PTSample}} object.
}
\details{
The loop state is not explicitly stored in a \code{\link{PTSample}} object.
It can be derived from the \code{\link{loopStart}} position and
\code{\link{loopLength}}. This method is provided as a convenient method
to get the state. Use either \code{\link{loopStart}} or \code{\link{loopLength}}
to change the state.
}
\examples{
data("mod.intro")

## Get the loop status of sample number 1
## (it has a loop):
loopState(PTSample(mod.intro, 1))

## Get the loop status of sample number 2
## (it has no loop):
loopState(PTSample(mod.intro, 2))
}
\author{
Pepijn de Vries
}
\seealso{
Other loop.methods: \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

