% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{paula_clock}
\alias{paula_clock}
\title{Paula clock table}
\format{a \code{data.frame} with two columns:
\itemize{
  \item{`frequency' A \code{numeric} value representing Paula's output rate in Hz.}
  \item{`video' A \code{character} string representing the two video modes.}
}}
\description{
Table that provides audio output frequencies for the Commodore Amiga
original chipset.
}
\details{
Paula was one of the custom chips on the original Commodore Amiga. This chip
was dedicated (amongst other tasks) to controlling audio playback. The
chip's output rate depended on the video mode used:
either `\href{https://en.wikipedia.org/wiki/PAL}{PAL}'
or `\href{https://en.wikipedia.org/wiki/NTSC}{NTSC}'. This table provides the
output rate for both video modes that can be used in calculating sample rates.
}
\examples{
data("paula_clock")
}
\references{
\url{https://en.wikipedia.org/wiki/Original_Chip_Set#Paula}
}

