% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{play}
\alias{play}
\alias{play.pt2mod}
\title{Play a ProTracker module}
\usage{
\method{play}{pt2mod}(x, duration = NA, options = pt2_render_options(), position = 0L, ...)
}
\arguments{
\item{x}{Object to be played.}

\item{duration}{Duration of the rendered output in seconds. When set to \code{NA}
the duration of the module is calculated and used for rendering.}

\item{options}{A list of options used for rendering the audio. Use
\code{\link[=pt2_render_options]{pt2_render_options()}} to obtain default options, or modify them.}

\item{position}{Starting position in the pattern sequence table (\code{pt2_pattern_table()}).
Should be a non negative value smaller than the mule length (\code{pt2_length()}).}

\item{...}{Arguments passed to \code{\link[=pt2_render]{pt2_render()}}.}
}
\value{
Returns an \verb{[audio::}$.audioInstance\verb{]} object which
allows you to control the playback (pause, resume, rewind).
}
\description{
Renders a ProTracker module as \code{\link[audio:audioSample]{audio::audioSample()}} and plays it.
}
\examples{
\dontrun{
mod <- pt2_read_mod(system.file("mod.intro", package = "ProTrackR2"))

## ctrl will contain the audioInstance that will let you control the audio playback:
ctrl <- play(mod)
}
}
\author{
Pepijn de Vries
}
