% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{pt2_render}
\alias{pt2_render}
\alias{pt2_render.pt2mod}
\title{Render ProTracker modules to a playable format}
\usage{
pt2_render(x, duration = NA, options = pt2_render_options(), ...)

\method{pt2_render}{pt2mod}(
  x,
  duration = NA,
  options = pt2_render_options(),
  position = 0L,
  ...
)
}
\arguments{
\item{x}{The object to be rendered}

\item{duration}{Duration of the rendered output in seconds. When set to \code{NA}
the duration of the module is calculated and used for rendering.}

\item{options}{A list of options used for rendering the audio. Use
\code{\link[=pt2_render_options]{pt2_render_options()}} to obtain default options, or modify them.}

\item{...}{Ignored}

\item{position}{Starting position in the pattern sequence table (\code{pt2_pattern_table()}).
Should be a non negative value smaller than the mule length (\code{pt2_length()}).}
}
\value{
Rendered audio inheriting the \code{\link[audio:audioSample]{audio::audioSample()}} class.
}
\description{
Renders a 16bit pulse-code modulation waveform from a ProTracker module.
The rendered format can be played on a modern machine.
}
\examples{
mod <- pt2_read_mod(system.file("mod.intro", package = "ProTrackR2"))
aud <- pt2_render(mod)
}
\author{
Pepijn de Vries
}
