% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_quant.R
\name{maximum_quantum}
\alias{maximum_quantum}
\title{MaxQuant proteomics data analysis}
\usage{
maximum_quantum(
  file,
  group_names,
  samples_per_group,
  imputation = FALSE,
  global_filtering = TRUE,
  independent = TRUE,
  filtering_value = 50,
  normalization = FALSE,
  parametric = FALSE,
  significance = "p"
)
}
\arguments{
\item{file}{The whole path to the MaxQuant ProteinGroups.txt file. The folders in the file path must be separated either with the forward slashes (/), or with the double backslashes (\\). See the example for inserting correctly the file path.}

\item{group_names}{A character vector specifying group names. The order of the names should align with the order of the sample groups in the input tsv file.}

\item{samples_per_group}{A numerical vector giving the number of samples in each group. The order of the numbers should align with the order of the names in group_names.}

\item{imputation}{Imputes all remaining missing values. Available methods: "LOD" for assigning the dataset's Limit Of Detection (lowest protein intensity identified), "LOD/2", "Gaussian_LOD" for selecting random values from the normal distribution around LOD with sd= 0.2*LOD, "zeros" for simply assigning 0 to MVs, mean" for replacing missing values with the mean of each protein across the entire dataset, "kNN" for a k-nearest neighbors imputation using 5 neighbors (from the package VIM) and "missRanger" for a random forest based imputation using predictive mean matching (from the package missRanger). By default it is set to FALSE (skips imputation).}

\item{global_filtering}{TRUE/FALSE. If TRUE, the per-protein percentage of missing values will be calculated across the entire dataset. If FALSE, it will be calculated separately for each group, allowing proteins to remain in the analysis if they meet the criteria within any group. By default it is set to TRUE.}

\item{independent}{TRUE/FALSE If TRUE, the samples come from different populations, if FALSE they come from the same population (Dependent samples). By default, it is set to TRUE. If set to FALSE, the numbers given in the samples_per_group param must be equal to each other.}

\item{filtering_value}{The maximum allowable percentage of missing values for a protein. Proteins with missing values exceeding this percentage will be excluded from the analysis. By default it is set to 50.}

\item{normalization}{The specific method for normalizing the data.By default it is set to FALSE. Options are FALSE for no normalization of the data, "log2" for a simple log2 transformation, "Quantile" for a quantiles based normalization  and "Cyclic_Loess" for a Cyclic Loess normalization of the log2 data, "median" for a median one, "TIC" for Total Ion Current normalization, "VSN" for Variance Stabilizing Normalization and "PPM" for Parts per Million transformation of the data.}

\item{parametric}{TRUE/FALSE. Specifies the statistical tests that will be taken into account for creating the PCA plots and heatmap. By default it is set to FALSE (non-parametric).}

\item{significance}{"p" or "BH" Specifies which of the p-values (nominal vs BH adjusted for multiple hypothesis) will be taken into account for creating the PCA plots and the heatmap. By default it is set to "p" (nominal p-value).}
}
\value{
Returns the complete output of the exploratory analysis: i) The processed, or filtered/normalized data ii) Statistical output containing results for the parametric (limma+ANOVA) and non-parametric tests (Wilcoxon+Kruskal-Wallis+PERMANOVA), along with statistical tests for heteroscedasticity, iii) Quality metrics for the input samples iv) QC plots and exploratory visualizations.
}
\description{
Processes the MaxQuant proteomics dataset and performs exploratory statistical analysis for a single categorical variable. Accepts as input the ProteinGroups.txt file.
}
\examples{
#Example of running the function with paths for two groups.
# The file path is a placeholder, replace it with an actual file.



proteinGroups.txt <- system.file("extdata", "proteinGroups.txt", package = "ProtE")
# Copy the file to a temporary directory for CRAN checks
temp_file <- file.path(tempdir(), "proteinGroups.txt")
file.copy(proteinGroups.txt, temp_file, overwrite = TRUE)

maximum_quantum(file = temp_file,
       group_names = c("Healthy","Control"),
       samples_per_group = c(4,4), filtering_value = 80)


}
