% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lasso_fista}
\alias{lasso_fista}
\title{Lasso regression with fixed step with FISTA algorithm}
\usage{
lasso_fista(data,y,x,lambda,max_step=10000,type="Gaussian",image=TRUE,ini=0.5,tol=10^-7)
}
\arguments{
\item{data}{name of the dataset}

\item{y}{name of the dependent variables}

\item{x}{name of the independent variable}

\item{lambda}{a vector of lambda-value to be evaluated in the regression}

\item{max_step}{maximum number of steps}

\item{type}{type of response variable, by default, it is 'Gaussian' for continuos response and can be modified as 'Binomial' for binary response}

\item{image}{logical, if TRUE, the evolution of errors in term of lambda values will be plotted}

\item{ini}{initial value for the coefficients}

\item{tol}{tolerance for convergence, it is 10^-7 by default}
}
\value{
A list containing:
\itemize{
  \item{\code{coefficients}: A matrix where each column represents the estimated regression coefficients for a different lambda value.}
  \item{\code{error_evolution}: A numeric vector tracking the error at certain step.}
  \item{\code{num_steps}: An integer vector indicating the number of steps in which errors are calculated.}
}
}
\description{
the function carries out the Lasso regression using fixed step using FISTA algorithm.
}
\details{
lasso_fista
}
\examples{
library("glmnet")
data("QuickStartExample")
test<-as.data.frame(cbind(QuickStartExample$y,QuickStartExample$x))
lasso_fista(test,"V1",colnames(test)[2:21],lambda=0.1,image=TRUE,max_step=1000)
}
