% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_compute.R
\name{compute_single_measure}
\alias{compute_single_measure}
\title{Compute Performance Measures}
\usage{
compute_single_measure(
  dgm_name,
  measure_name,
  method,
  method_setting,
  conditions,
  measure_fun,
  measure_mcse_fun,
  power_test_type = "p_value",
  estimate_col = "estimate",
  true_effect_col = "mean_effect",
  ci_lower_col = "ci_lower",
  ci_upper_col = "ci_upper",
  p_value_col = "p_value",
  bf_col = "BF",
  convergence_col = "convergence",
  power_threshold_p_value = 0.05,
  power_threshold_bayes_factor = 10,
  method_replacements = NULL,
  n_repetitions = 1000,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM name}

\item{measure_name}{Name of the measure to compute (e.g., "bias", "mse")}

\item{method}{Character vector of method names}

\item{method_setting}{Character vector of method settings, must be same length as method}

\item{conditions}{Data frame of conditions from dgm_conditions()}

\item{measure_fun}{Function to compute the measure}

\item{measure_mcse_fun}{Function to compute the MCSE for the measure}

\item{power_test_type}{Character vector specifying the test type for power computation:
"p_value" (default) or "bayes_factor" for each method. If a single value is provided, it is
repeated for all methods.}

\item{estimate_col}{Character string specifying the column name containing parameter estimates. Default is "estimate"}

\item{true_effect_col}{Character string specifying the column name in conditions data frame containing true effect sizes. Default is "mean_effect"}

\item{ci_lower_col}{Character string specifying the column name containing lower confidence interval bounds. Default is "ci_lower"}

\item{ci_upper_col}{Character string specifying the column name containing upper confidence interval bounds. Default is "ci_upper"}

\item{p_value_col}{Character string specifying the column name containing p-values. Default is "p_value"}

\item{bf_col}{Character string specifying the column name containing Bayes factors. Default is "BF"}

\item{convergence_col}{Character string specifying the column name containing convergence indicators. Default is "convergence"}

\item{power_threshold_p_value}{Numeric threshold for power computation with p-values.
Default is 0.05 (reject H0 if p < 0.05).}

\item{power_threshold_bayes_factor}{Numeric threshold for power computation with Bayes factors.
Default is 10 (reject H0 if BF > 10)}

\item{method_replacements}{Named list of replacement method specifications. Each element should be named
with the "method-method_setting" combination (e.g., "RMA-default") and contain a named list with:
\itemize{
\item{\code{method}: Character vector of replacement method names}
\item{\code{method_setting}: Character vector of replacement method settings (same length as methods)}
\item{\code{power_test_type}: Optional character vector of power test types for each replacement method (same length as methods). If not specified, uses the main power_test_type parameter}
}
If multiple elements are specified within the vectors, these replacements are applied consecutively
in case the previous replacements also failed to converge.
Defaults to \code{NULL}, i.e., omitting repetitions without converged results on method-by-method basis.}

\item{n_repetitions}{Number of repetitions in each condition. Necessary method replacement. Defaults to \code{1000}.}

\item{overwrite}{Logical indicating whether to overwrite existing results. If FALSE (default), will skip computation for method-measure combinations that already exist}

\item{...}{Additional arguments passed to measure functions}
}
\value{
TRUE upon successfully computation of the results file
}
\description{
This function provides a modular and extensible way to compute performance
measures (PM) for Data-Generating Mechanisms (DGMs). It handles different types
of measures and automatically determines the required arguments for each measure
function.
}
