% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_remove_blinks.R
\name{detect_blinks_by_size}
\alias{detect_blinks_by_size}
\title{detect blinks by a change in pupil size}
\usage{
detect_blinks_by_size(
  data,
  pupil,
  threshold = 2.5,
  extend_forward = 0,
  extend_back = 0
)
}
\arguments{
\item{data}{dataset of class PupillometryR}

\item{pupil}{column name for pupil data}

\item{threshold}{velocity threshold for blink detection}

\item{extend_forward}{number of observations to remove forward of blink}

\item{extend_back}{number of obervations to remove behind blink}
}
\value{
returns dataframe with blinks removed including forward and back, and data in blink column.
}
\description{
This allows the user to set a threshold for pupil size and remove anything classed as a blink as a result
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)

Sdata2 <- detect_blinks_by_size(data = Sdata,
pupil = LPupil,
threshold = 2.5,
extend_forward = 0,
extend_back = 0)

}
