% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_remove_blinks.R
\name{detect_blinks_by_velocity}
\alias{detect_blinks_by_velocity}
\title{detect blinks by a change in velocity}
\usage{
detect_blinks_by_velocity(
  data,
  pupil,
  threshold = 0.1,
  extend_forward = 0,
  extend_back = 0
)
}
\arguments{
\item{data}{dataset of class PupillometryR}

\item{pupil}{column name for pupil data}

\item{threshold}{velocity threshold for blink detection}

\item{extend_forward}{number of observations to remove forward of blink}

\item{extend_back}{number of obervations to remove behind blink}
}
\value{
returns dataframe with blinks removed including forward and back, and data in blink column.
}
\description{
This allows the user to set a threshold for velocity and remove anything classed as a blink as a result
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)

Sdata2 <- detect_blinks_by_velocity(data = Sdata,
pupil = LPupil,
threshold = 0.1,
extend_forward = 0,
extend_back = 0)

}
