% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALaD.R
\name{mleALaD}
\alias{mleALaD}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric Laplace distribution.}
\usage{
mleALaD(y)
}
\arguments{
\item{y}{This is a vector of quantiles.}
}
\value{
The maximum likelihood estimate of parameter \eqn{ \theta=(\mu,\phi,\alpha)} of the quantile-based asymmetric Laplace distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha)} in the quantile-based asymmetric Laplace distribution
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019a).
 See also in Yu and Zhang (2005). The linear programing (LP) algorithm is used to obtain a solution to the maximization problem.
 The LP algorithm can be found in  Koenker (2005). See also \code{\link[ald:mleALD]{mleALD}} in the Package \pkg{ald}.
}
\examples{
## Example:
y=rnorm(100)
mleALaD(y)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.


 Koenker, R. (2005). \emph{Quantile Regression}. Cambridge University Press.


 Yu., K, and Zhang, J. (2005). A three-parameter asymmetric Laplace distribution and its extension. \emph{Communications in Statistics–Theory and Methods}, \bold{34}(9-10), 1867–1879.

}
}
