\name{findTh}

\alias{findTh}

\title{Find Calibration Thresholds}

\description{
This function finds calibration thresholds for splitting base variables into the 
desired number of groups using cluster analysis.
}

\usage{
findTh(x, groups = 2, hclustm = "complete", distm = "euclidean")
}

\arguments{
  \item{x}{An interval or ratio-scaled base variable}
  \item{groups}{A vector of integers with the desired number of groups, see \code{?cutree}}
  \item{hclustm}{The agglomeration (clustering) method to be used, see \code{?hclust}}
  \item{distm}{The distance measure to be used, see \code{?dist}}
}

\value{
A numeric vector of suggested threshold(s) for dividing base variables 
into the desired number of groups.
}

\note{Default values from the \code{hclust()} method and the \code{dist()} method are used for 
both the distance measure \code{distm} and the clustering method \code{hclustm}. Some prefer to 
use \code{"average"} for the \code{hclust()} method, but results are generally the same.
}

\seealso{\code{\link{cutree}}, \code{\link{hclust}}, \code{\link{dist}}}

\examples{
# 15 random values between 1 and 100 
x <- sample(1:100, size = 15)

# split into 2 groups for csQCA
findTh(x)

# split into 3 groups for mvQCA
findTh(x, groups = 3)
}

\keyword{functions}

