% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQF.plot.R
\name{EQF.plot}
\alias{EQF.plot}
\title{EQF plot}
\usage{
EQF.plot(result, plot.all = TRUE, plot.chr = TRUE)
}
\arguments{
\item{result}{list. The data list of the output from LOD.QTLdetect()
or EQF.permu().}

\item{plot.all}{logical. If being TURE, output one figure of the
EQF values over the bins.}

\item{plot.chr}{logical. If being TURE, output the figures of the
EQF values over the bins of each chromosome.}
}
\value{
One or several EQF plots.
}
\description{
Depict the EQF plot by the result of the permutation process to
detect the QTL hotspot.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))

# run and result
EQF.plot(LOD.QTLdetect.result)
EQF.plot(EQF.permu.result)
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056.
}
\seealso{
\code{\link[QTLEMM]{LOD.QTLdetect}}
\code{\link[QTLEMM]{EQF.permu}}
}
