% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alg.CS.R
\name{alg.CS}
\alias{alg.CS}
\title{CS quantile-based clustering algorithm}
\usage{
alg.CS(data, k = 2, eps = 1e-08, it.max = 100, B = 30, lambda = rep(1,
  p))
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations. Categorical variables are not allowed. If a matrix or data frame, rows correspond to observations and columns correspond to variables.}

\item{k}{The number of clusters. The default is k=2.}

\item{eps}{The relative convergence tolerances for objective function. The default is set to 1e-8.}

\item{it.max}{A number that gives integer limits on the number of the CS algorithm iterations. By default, it is set to 100.}

\item{B}{The number of times the initialization step is repeated; the default is 30.}

\item{lambda}{The initial value for lambda_j, the variable scaling parameters. By default, lambdas are set to be equal to 1.}
}
\value{
A list containing the following elements:
\item{cl}{A vector whose [i]th entry is classification of observation i in the test data.}
\item{qq}{A matrix whose [h,j]th entry is the theta-quantile of variable j in cluster h.}
\item{theta}{The estimated common theta.}
\item{Vseq}{The values of the objective function V at each step of the algorithm.}
\item{V}{The final value of the objective function V.}
\item{lambda}{A vector containing the scaling factor for each variable.}
}
\description{
This function allows to run the CS (Common theta and Scaled variables through lambda_j) version of the quantile-based clustering algorithm.
}
\details{
Algorithm CS: Common theta and Scaled variables via lambda_j. A common value of theta is taken but variables are scaled through lambda_j.
}
\examples{
out <- alg.CS(iris[,-5],k=3)
out$theta
out$qq
out$lambda

table(out$cl)
}
\references{
C. Hennig, C. Viroli, L. Anderlucci (2018). \emph{Quantile-based clustering}. \url{http://arxiv.org/abs/1806.10403}
}
