% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{settings}
\alias{settings}
\alias{QuantTools_settings}
\alias{QuantTools_settings_defaults}
\title{QuantTools settings}
\usage{
QuantTools_settings(settings = NULL)

QuantTools_settings_defaults()
}
\arguments{
\item{settings}{named list of settings values or settings names vector}
}
\description{
QuantTools settings
}
\details{
Controls package settings.


List of available settings:
\tabular{lll}{
finam_storage      \tab Finam local storage path        \cr
iqfeed_storage     \tab IQFeed local storage path       \cr
moex_storage       \tab MOEX local storage path         \cr
moex_data_url      \tab MOEX data url                   \cr
finam_storage_from \tab Finam storage first date        \cr
iqfeed_storage_from\tab IQFeed storage first date       \cr
moex_storage_from  \tab MOEX storage first date         \cr
finam_symbols      \tab Finam  symbols to store         \cr
iqfeed_symbols     \tab IQFeed symbols to store         \cr
iqfeed_port        \tab IQFeed historical port number   \cr
iqfeed_host        \tab IQFeed host                     \cr
iqfeed_timeout     \tab IQFeed connection timeout       \cr
iqfeed_buffer      \tab IQFeed number of bytes buffer   \cr
iqfeed_verbose     \tab IQFeed verbose internals?       \cr
temp_directory     \tab temporary directory location    \cr
}
}
\examples{
\donttest{

# list all settings
QuantTools_settings()

# set defaults
QuantTools_settings_defaults()

# change a setting
QuantTools_settings( list( iqfeed_verbose = TRUE ) )

# To make R remember your settings please add the following code
# to .Rprofile file stored in your home directory path.expand('~'):

suppressMessages( library( QuantTools ) )

QuantTools_settings( settings = list(#'
  iqfeed_storage = paste( path.expand('~') , 'Market Data', 'iqfeed', sep = '/' ),
  iqfeed_symbols = c( 'AAPL', '@ES#' ),
  iqfeed_storage_from = format( Sys.Date() - 3 )
) )

}
}
