% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlashQC.R
\name{Create_prior_cutTree}
\alias{Create_prior_cutTree}
\title{Create priors from hierarchical clustering}
\usage{
Create_prior_cutTree(tree, Schrod_cells, NClus, jitter = FALSE)
}
\arguments{
\item{tree}{The tree generated by Cellular_preclustering}

\item{Schrod_cells}{The classic output from Schrodinger function}

\item{NClus}{the number of clusters to cut the data}

\item{jitter}{Should it jitter weights and centers around values found?}
}
\value{
returns a list with:
\describe{
 \item{weigths}{The proportion of mutations in each cluster}
 \item{centers}{A list with a numeric vector for each sample, with the cellularity of each cluster}
 }
 
 @importFrom stats cutree
}
\description{
Creates weights and position priors from the hierachical clustering (tree) given
a number of clusters Nclust. The centers of each cluster is found by
\eqn{Center = \frac{\sum\limits_{m \in cluster}{Normalized Alt_{m}}}{\sum\limits_{m \in cluster}{Normalized Alt_{m}}}}
}
