# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Triplet and quartet distances with tqDist
#' 
#' Functions to calculate triplet and quartet distances between pairs of trees.
#' Input is not checked for sanity.
#' 
#' @param file,file1,file2 Paths to files containing a tree or trees in Newick format.
#' 
#' @return The distance between the requested trees.
#' 
#' @author Martin R. Smith, after Andreas Sand
#' 
#' @references \insertRef{Sand2014}{Quartet}
#' 
#' @keywords internal
#' @export
tqdist_QuartetDistance <- function(file1, file2) {
    .Call(`_Quartet_tqdist_QuartetDistance`, file1, file2)
}

#' @describeIn tqdist_QuartetDistance Agreement of each quartet
#' @export
tqdist_QuartetAgreement <- function(file1, file2) {
    .Call(`_Quartet_tqdist_QuartetAgreement`, file1, file2)
}

#' @describeIn tqdist_QuartetDistance Distance between pairs
#' @export
tqdist_PairsQuartetDistance <- function(file1, file2) {
    .Call(`_Quartet_tqdist_PairsQuartetDistance`, file1, file2)
}

#' @describeIn tqdist_QuartetDistance Distance between pairs
#' @export
tqdist_OneToManyQuartetAgreement <- function(file1, fileMany) {
    .Call(`_Quartet_tqdist_OneToManyQuartetAgreement`, file1, fileMany)
}

#' @describeIn tqdist_QuartetDistance Distance between all pairs
#' @export
tqdist_AllPairsQuartetDistance <- function(file) {
    .Call(`_Quartet_tqdist_AllPairsQuartetDistance`, file)
}

#' @describeIn tqdist_QuartetDistance Agreement between all pairs of trees
#' @export
tqdist_AllPairsQuartetAgreement <- function(file) {
    .Call(`_Quartet_tqdist_AllPairsQuartetAgreement`, file)
}

#' @describeIn tqdist_QuartetDistance Triplet distance between two trees
#' @export
tqdist_TripletDistance <- function(file1, file2) {
    .Call(`_Quartet_tqdist_TripletDistance`, file1, file2)
}

#' @describeIn tqdist_QuartetDistance Triplet distance between pairs
#' @export
tqdist_PairsTripletDistance <- function(file1, file2) {
    .Call(`_Quartet_tqdist_PairsTripletDistance`, file1, file2)
}

#' @describeIn tqdist_QuartetDistance Triplet distance between all pairs
#' @export
tqdist_AllPairsTripletDistance <- function(file) {
    .Call(`_Quartet_tqdist_AllPairsTripletDistance`, file)
}

