% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResolvedQuartets.R
\name{ResolvedQuartets}
\alias{ResolvedQuartets}
\alias{ResolvedTriplets}
\title{Count resolved quartets}
\usage{
ResolvedQuartets(tree, countTriplets = FALSE)

ResolvedTriplets(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{countTriplets}{Logical; if \code{TRUE}, the function will return the number
of triplets instead of the number of quartets.}
}
\value{
\code{ResolvedQuartets()} returns a vector of length two, listing the
number of quartets (or triplets)
that are [1] resolved; [2] unresolved in the specified tree.
}
\description{
Counts how many quartets are resolved or unresolved in a given tree,
following Brodal \emph{et al.} (2013).
}
\details{
Trees with more than 477 leaves risk encountering integer overflow errors,
as the number of quartets is larger than can be stored in R's signed
32-bit integer representation.  If warnings are thrown, check subsequent
calculations for errors.
}
\section{Functions}{
\itemize{
\item \code{ResolvedTriplets()}: Convenience function to calculate the number of
resolved/unresolved triplets.

}}
\examples{
data(sq_trees)

ResolvedTriplets(sq_trees$collapse_some)
# Equivalent to:
ResolvedQuartets(sq_trees$collapse_some, countTriplets = TRUE)

vapply(sq_trees, ResolvedQuartets, integer(2))


}
\references{
\itemize{
\item \insertRef{Brodal2013}{Quartet}
}
}
\seealso{
Other quartet counting functions: 
\code{\link{AllQuartets}()},
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareQuartets}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{quartet counting functions}
