% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negbin.R
\name{negbin}
\alias{negbin}
\title{Negative Binomial Family}
\usage{
negbin(link = "log", overdisp = stop("'overdisp' must be specified"))
}
\arguments{
\item{link}{The link funciton. Only \code{'log'} is supported currently.}

\item{overdisp}{A positive overdispersion parameter. This is the same as
\code{1/size}, where \code{size} is the same as in \code{\link{dnbinom}}.}
}
\value{
A list of class \code{c("fbrNBfamily", "family")}, containing 
  all components from the \code{mgcv::\link[mgcv]{negbin}} followed by a call to 
  \code{\link[mgcv]{fix.family.link}} with the following additional components: 
\describe{
 \item{setTheta}{A function setting the overdispersion parameter to a 
     specified value. The input argument to this function is \code{1/overdisp}.}
 \item{cumulant3}{A function returning the third cumulant of the distribution. 
     Input arguments are the mean \code{mu} and variance \code{var}.} 
 \item{cumulant4}{A function returning the fourth cumulant of the distribution. 
     Input arguments are the mean \code{mu} and variance \code{var}.} 
 \item{initializers}{A list of expressions that can be used to provide 
     starting values for iterative fitting. See the \code{initialize} component
     of the result from \code{\link[stats:family]{family}}.}
 }
}
\description{
This is an extension of the \code{\link[mgcv:negbin]{negbin}} in the
 \code{mgcv} package, providing additional components related to the 
 negative binomial distribution with log link. 
 
 Compared to \code{\link[mgcv]{negbin}} followed by a call to 
 \code{\link[mgcv]{fix.family.link}} in the \code{mgcv} package
 this function provides a different implementation of \code{linkinv}, 
 added a component \code{initializers} of 
 initialization expressions, added the third and fourth order 
 cumulant functions \code{cumulant3} and \code{cumulant4}.
}
\examples{
 negbin('log', 1)
}
