% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_fits.R
\name{growth.gcFitModel}
\alias{growth.gcFitModel}
\title{Fit nonlinear growth models to growth data}
\usage{
growth.gcFitModel(time, data, gcID = "undefined", control = growth.control())
}
\arguments{
\item{time}{Vector of the independent variable (usually time).}

\item{data}{Vector of dependent variable (usually growth values).}

\item{gcID}{(Character) The name of the analyzed sample.}

\item{control}{A \code{grofit.control} object created with \code{\link{growth.control}}, defining relevant fitting options.}
}
\value{
A \code{gcFitModel} object that contains physiological parameters and information about the best fit. Use \code{\link{plot.gcFitModel}} to visualize the parametric fit and growth equation.
\item{raw.time}{Raw time values provided to the function as \code{time}.}
\item{raw.data}{Raw growth data provided to the function as \code{data}.}
\item{gcID}{(Character) Identifies the tested sample.}
\item{fit.time}{Fitted time values.}
\item{fit.data}{Fitted growth values.}
\item{parameters}{List of determined growth parameters.}
\itemize{
\item \code{A}: {Maximum growth.}
\item \code{dY}: {Difference in maximum growth and minimum growth of the fitted model.}
\item \code{mu}: {Maximum growth rate (i.e., maximum in first derivative of the spline).}
\item \code{lambda}: {Lag time.}
\item \code{b.tangent}: {Intersection of the tangent at the maximum growth rate with the abscissa.}
\item \code{fitpar}: {For some models: list of additional parameters used in the equations describing the growth curve.}
\item \code{integral}: {Area under the curve of the parametric fit.}
}
\item{model}{(Character) The model that obtained the fit with the lowest AIC, determined by \code{\link{AIC}}.}
\item{nls}{\code{nls} object for the chosen model generated by the \code{\link{nls}} function.}
\item{reliable}{(Logical) Indicates whether the performed fit is reliable (to be set manually).}
\item{fitFlag}{(Logical) Indicates whether a parametric model was successfully fitted on the data.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{growth.gcFitModel} determines a parametric growth model that best describes the data.
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Perform parametric fit
TestFit <- growth.gcFitModel(time, data, gcID = 'TestFit',
                 control = growth.control(fit.opt = 'm'))

plot(TestFit, basesize = 18, eq.size = 1.5)

}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07
}
\seealso{
Other growth fitting functions: 
\code{\link{growth.drFit}()},
\code{\link{growth.gcBootSpline}()},
\code{\link{growth.gcFitLinear}()},
\code{\link{growth.gcFitSpline}()},
\code{\link{growth.gcFit}()},
\code{\link{growth.workflow}()}
}
\concept{growth fitting functions}
