% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rdm.data}
\alias{rdm.data}
\title{The function calls the \code{baranyi} function to generate curves between time zero and \code{t} and adds some random noise to the x- and y-axes. The three growth parameters given as input values will be slightly changed to produce different growth curves. The resulting datasets can be used to test the \code{\link{growth.workflow}} function.}
\usage{
rdm.data(d, y0 = 0.05, tmax = 24, mu = 0.6, lambda = 5, A = 3, label = "Test1")
}
\arguments{
\item{d}{Numeric value, number of data sets. If \code{d} is a vector, only the first entry is used.}

\item{y0}{Numeric value, start growth. If \code{t} is a vector, only the first entry is used.}

\item{tmax}{Numeric value, number of time points per data set. If \code{t} is a vector, only the first entry is used.}

\item{mu}{Numeric value, maximum slope. If \code{mu} is a vector, only the first entry is used.}

\item{lambda}{Numeric value, lag-phase. If \code{lambda} is a vector, only the first entry is used.}

\item{A}{Numeric value, maximum growth. If \code{A} is a vector, only the first entry is used.}

\item{label}{Character string, condition label  If \code{label} is a vector, only the first entry is used.}
}
\value{
A list containing simulated data for three tests (e.g., 'organisms'):
\item{time}{numeric matrix of size \code{d}x\code{t}, each row represent the time points for which growth data is simulated and stored in each row of \code{data}.}
\item{data}{data.frame of size \code{d}x(3+\code{t}), 1. column, character as an experiment identifier; 2. column: Replicate number; 3. column: concentration of substrate of a compound under which the experiment is obtained; 4.-(3+t). column: growth data corresponding to the time points in \code{time}.}
}
\description{
The function calls the \code{baranyi} function to generate curves between time zero and \code{t} and adds some random noise to the x- and y-axes. The three growth parameters given as input values will be slightly changed to produce different growth curves. The resulting datasets can be used to test the \code{\link{growth.workflow}} function.
}
\examples{
# Create random growth data set
rnd.data1 <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')
rnd.data2 <- rdm.data(d = 35, mu = 0.6, A = 4.5, label = 'Test2')

rnd.data <- list()
rnd.data[['time']] <- rbind(rnd.data1$time, rnd.data2$time)
rnd.data[['data']] <- rbind(rnd.data1$data, rnd.data2$data)

# Run growth curve analysis workflow
gcFit <- growth.gcFit(time = rnd.data$time,
                       data = rnd.data$data,
                       parallelize = FALSE,
                       control = growth.control(fit.opt = 's',
                                                suppress.messages = TRUE))

\donttest{
# Perform dose-response analysis
drFit <- growth.drFit(gcTable = gcFit$gcTable,
             control = growth.control(dr.parameter = 'mu.spline'))

# Inspect results
summary(drFit)
plot(drFit)
}

}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07
}
