% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_plots.R
\name{plot.flFitLinear}
\alias{plot.flFitLinear}
\title{Generic plot function for \code{flcFittedLinear} objects. Plot the results of a linear regression on ln-transformed data}
\usage{
\method{plot}{flFitLinear}(
  x,
  log = "",
  which = c("fit", "diagnostics", "fit_diagnostics"),
  pch = 21,
  cex.point = 1,
  cex.lab = 1.5,
  cex.axis = 1.3,
  lwd = 2,
  color = "firebrick3",
  y.lim = NULL,
  x.lim = NULL,
  plot = TRUE,
  export = FALSE,
  height = ifelse(which == "fit", 7, 5),
  width = ifelse(which == "fit", 9, 9),
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{flFittedLinear} object created with \code{\link{flFitLinear}} or stored within a \code{flFitRes} or \code{flFit} object created with \code{\link{fl.workflow}} or \code{\link{flFit}}, respectively.}

\item{log}{("x" or "y") Display the x- or y-axis on a logarithmic scale.}

\item{which}{("fit" or "diagnostics") Display either the results of the linear fit on the raw data or statistical evaluation of the linear regression.}

\item{pch}{(Numeric) Shape of the raw data symbols.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{lwd}{(Numeric) Line width.}

\item{color}{(Character string) Enter color either by name (e.g., red, blue, coral3) or via their hexadecimal code (e.g., #AE4371, #CCFF00FF, #0066FFFF). A full list of colors available by name can be found at http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis as a vector in the form \code{c(l, u)}.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis as a vector in the form \code{c(l, u)}.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Further arguments to refine the generated base R plot.}
}
\value{
A plot with the linear fit.
}
\description{
\code{plot.flFitLinear} shows the results of a linear regression and visualizes raw data, data points included in the fit, the tangent obtained by linear regression, and the lag time.
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flFitLinear(time = time,
                       fl_data = data,
                       ID = "TestFit",
                       control = fl.control(fit.opt = "l", x_type = "time",
                       lin.R2 = 0.95, lin.RSD = 0.1,
                       lin.h = 20))

plot(TestFit)
}
