% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_tops_popcnts}
\alias{get_rafs_tops_popcnts}
\title{Get top popularity counts (popcnts) from FS results}
\usage{
get_rafs_tops_popcnts(fs_results, n_top_range = 2:15)
}
\arguments{
\item{fs_results}{RAFS FS results as obtained from \code{\link{compute_fs_results}}}

\item{n_top_range}{range of top number to obtain popcnts for}
}
\value{
A nested \code{\link{list}} with popcnts.
  The first level is per the number of top variables.
  The second (and last) level is popcnts per top variable.
}
\description{
This function obtains popularity counts (popcnts) of top variables computed
over all runs of FS.
}
\details{
These results might be fed into further helper functions:
\code{\link{get_rafs_top_reps_from_popcnts}} and \code{\link{get_rafs_all_reps_from_popcnts}}.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
fs_results <- compute_fs_results(madelon$data, madelon$decision, 2, c(12345))
get_rafs_tops_popcnts(fs_results, 2:5)
}
