% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupfunctions.R
\name{aqs_sign_up}
\alias{aqs_sign_up}
\title{aqs_sign_up}
\usage{
aqs_sign_up(email)
}
\arguments{
\item{email}{a R character object which represents the email account that
will be used to register with the AQS API or change an
existing user's key. A verification email will be sent to
the account specified. Follow the instructions
in the verification e-mail before proceeding to use any other
functionality of the AQS API. Register your credential
with the @3 \code{\link[=aqs_credentials]{aqs_credentials()}} before using the
other functions in this library.}
}
\value{
None
}
\description{
\lifecycle{stable}
Use this service to register as a new user or to reset an
existing user's key. A verification email will be sent to the
email account specified. To reset a password: If the request is
made with an email that is already registered, a new key will
be issued for that account and emailed to the listed address.
Usage is the same in either case. Refer to the email
message for further instructions before continuing.
}
\note{
The '@' character needs to be escaped with the '/' character.
}
\examples{
# to register a new user or generate a new key with the email
          #  address "John.Doe/@myemail.com"
          \dontrun{aqs_sign_up(email = "John.Doe/@myemail.com")}
          #  after calling this function please follow the instructions that
          #  are sent in the verification e-mail before proceeding.
}
