% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byma.R
\name{aqs_qa_annualpeferomanceeval_by_MA}
\alias{aqs_qa_annualpeferomanceeval_by_MA}
\title{aqs_qa_annualpeferomanceeval_by_MA}
\usage{
aqs_qa_annualpeferomanceeval_by_MA(
  parameter,
  bdate,
  edate,
  MA_code,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be
returned.}

\item{MA_code}{a R character object which represents the 4 digit AQS
Monitoring Agency code (with leading zeroes).}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of quality assurance
performance evaluation data. for all monitoring sites for with
the MA_code requested for the time frame between bdate and edate.
An AQS_Data_Mart_APIv2 is a 2 item named list in which the first
item ($Header) is a tibble of header information from the AQS API
and the second item ($Data) is a tibble of the data returned.
}
\description{
\lifecycle{stable}
Returns quality assurance performance evaluation data - aggregated by
by Monitoring agency (MA) for a parameter
code aggregated by matching input parameter and MA_code for the
time frame between bdate and edate.
}
\note{
The AQS API only allows for a single year of quality assurance
Annual Performance Evaluation data to be retrieved at a
time. This function conveniently extracts date information from the
bdate and edate parameters then makes repeated calls to the AQSAPI
retrieving a maximum of one calendar year of data at a time. Each
calendar year of data requires a separate API call so multiple years
of data will require multiple API calls. As the number of years of
data being requested increases so does the length of time that it
will take to retrieve results. There is also a 5 second wait time
inserted between successive API calls to prevent overloading the API
server. This operation has a linear run time of
/(Big O notation: O/(n + 5 seconds/)/).
}
\examples{
          #Returns an AQS_Data Mart_APIv2 S3 object or a tibble
          #  containing annual performance evaluation data for ozone where
          #  the monitoring agency is the Alabama Department of
          #  Environmental Management (MA_code 0013).
          \dontrun{aqs_qa_annualpeferomanceeval_by_MA(parameter = "44201",
                                                  bdate = as.Date("20170101",
                                                          format = "\%Y\%m\%d"),
                                                  edate = as.Date("20171231",
                                                          format = "\%Y\%m\%d"),
                                                          MA_code = "0013"
                                                        )
                  }
}
\seealso{
Other Aggregate _by_MA functions: 
\code{\link{aqs_qa_annualperformanceevaltransaction_by_MA}()},
\code{\link{aqs_qa_blanks_by_MA}()},
\code{\link{aqs_qa_collocated_assessments_by_MA}()},
\code{\link{aqs_qa_flowrateaudit_by_MA}()},
\code{\link{aqs_qa_flowrateverification_by_MA}()},
\code{\link{aqs_qa_one_point_qc_by_MA}()},
\code{\link{aqs_qa_pep_audit_by_MA}()}
}
\concept{Aggregate _by_MA functions}
