% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEU_power_comparison_Power_vs_n.R
\name{SEU_power_comparison_Power_vs_n}
\alias{SEU_power_comparison_Power_vs_n}
\title{Comparison of Powers for Sample Sizes under Different SEU Randomization
Methods (Binary Responses)}
\usage{
SEU_power_comparison_Power_vs_n(n_seq, nstart_seq, p, urn_comp,
nstop_mat, replication, group_allo, add_rule_index, add_rule, add_rule_full,
sig_level)
}
\arguments{
\item{n_seq}{A sequence of settings' number of patients.
The default is c(50, 100, 150, 200).}

\item{nstart_seq}{The burn-in sample size of each arm. The default is
n_seq/20 = c(2, 5, 8, 10).}

\item{p}{A vector of probabilities containing probabilities
for each treatment arm (where the first element refers to the control arm).
The length of p should correspond to the number of treatment arms.
The default is p = c(0.3, 0.3, 0.6).}

\item{urn_comp}{A vector of current urn composition. The default is NULL,
which indicates no ball in the urn.}

\item{nstop_mat}{A matrix of sample size stopping caps for each arm.
Each row corresponds to each n in n_seq, and each column represents each arm.
The trial stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 The group_allo will be applied to all n (from each n_seq).
 Any value greater than n  will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{add_rule_index}{Supply a number of 1, 2 or 3 indicting the
addition rules to target allocation functions.
1 = randomized play-the-winner (RPW) rule that targets the urn allocation
2 = the SEU model that targets Neyman allocation;
3 = the SEU model that targets Rosenberger allocation;'
4 = the SEU model that assigns probability of 0.6+1/K to winner at each step.
The default is 1.}

\item{add_rule}{Supply a user-specified addition rules function of x.df and
arms when add_rule_index is NULL. Default is NULL. (See SEU_BINARY_raw for
details on x.df and arms.)}

\item{add_rule_full}{Indicator of reference data for updating addition rule.
If TRUE, the addition rule is updated by full observation at each group
allocation. If FALSE,the addition rule is updated by each group observation.
The default is FALSE for add_rule_index=1 and TRUE otherwise.}

\item{sig_level}{Significant level (one-sided). The default is 0.05.}
}
\value{
\itemize{
  \item Allocation - Average and standard deviation (SD) of allocation distribution
  \item Estimation - Average and standard deviation of treatment effect
  \item Power_chisq - Average power of Chi-square test
  \item Power_oneside - Average power of one-sided Welch T-test performed for each of the k-th arm against H0: p_1>p_k without multiplicity adjustment
  \item Plot - Four figures of results: 1) Allocation mean and SD, 2) Estimated mean response and SD, 3) Power of Chi-square test, 4) Power of one-sided proportion test
}
}
\description{
Compares the power of tests under different sample sizes for the same
treatment effects and design through matrices and plots.
}
\details{
'SEU_power_comparison_Power_vs_n' reads different sample sizes as
well as the corresponding burn-in size and outputs allocation, estimated
rates and powers.
}
\examples{

## Default setting
SEU_power_comparison_Power_vs_n(
n_seq = seq(from = 50, to = 200, by = 50),
nstart_seq = round(seq(from = 50, to = 200, by = 50) / 20),
p = c(0.3, 0.3, 0.6),
urn_comp = NULL,
nstop_mat = NULL,
replication = 4,
group_allo = 1,
add_rule_index = 1,
add_rule = NULL,
add_rule_full = FALSE,
sig_level = 0.05
)


}
