% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmax_beta.r
\name{pmax_beta}
\alias{pmax_beta}
\title{Posterior Probability that a Particular Arm is the Best for Binary Endpoint}
\usage{
pmax_beta(
  armn,
  a1 = NULL,
  b1 = NULL,
  a2 = NULL,
  b2 = NULL,
  a3 = NULL,
  b3 = NULL,
  a4 = NULL,
  b4 = NULL,
  a5 = NULL,
  b5 = NULL,
  side,
  ...
)
}
\arguments{
\item{armn}{number of arms in the trial with values up to 5. When \code{armn}=2,
only \code{a1} to \code{a2} and \code{b1} to \code{b2} need to be specified.
When \code{armn}=3, only \code{a1} to \code{a3} and  \code{b1} to \code{b3} need to be specified.
When \code{armn}=4, only \code{a1} to \code{a4} and  \code{b1} to \code{b4} need to be specified.
When \code{armn}=5, \code{a1} to \code{a5} and  \code{b1} to \code{b5} need to be specified.}

\item{a1, b1}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)} for the arm to calculate the allocation probability of.}

\item{a2, b2}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)} for one of the remaining arms.}

\item{a3, b3}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)} for one of the remaining arms.}

\item{a4, b4}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)} for one of the remaining arms.}

\item{a5, b5}{\eqn{\alpha} and \eqn{\beta} in \eqn{Beta(\alpha,\beta)} for one of the remaining arms.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}} (such as rel.tol) from this function.}
}
\value{
a probability that a particular arm is the best in trials up to five arms.
}
\description{
Calculate posterior probability that a particular arm is the best in a trial using Bayesian response-adaptive randomization with
a control group (the Thall \eqn{\&} Wathen method). The conjugate prior distributions follow Beta (\eqn{Beta(\alpha,\beta)}) distributions
for binary outcomes in each arm and can be specified individually.
}
\details{
This function calculates the results of formula \eqn{Pr(p_k=max\{p_1,...,p_K\})} for
\code{side} equals to 'upper' and the results of formula \eqn{Pr(p_k=min\{p_1,...,p_K\})} for
\code{side} equals to 'lower'. This function returns the probability that the posterior probability of arm
\eqn{k} is maximal or minimal in trials with up to five arms.
}
\examples{
pmax_beta(armn=5,a1=8,b1=10,a2=5,b2=19,a3=8,b3=21,
a4=6, b4=35, a5=15, b5=4, side='upper')
pmax_beta(armn=4,a1=56,b1=98,a2=25,b2=70,a3=87,b3=107,
a4=106, b4=202, side='lower')
pmax_beta(armn=3,a1=60,b1=46,a2=55,b2=46,a3=35,b3=36,side='upper')
}
