% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{backend_dbplyr}
\alias{backend_dbplyr}
\alias{db_save_query.AthenaConnection}
\alias{db_explain.AthenaConnection}
\alias{db_query_fields.AthenaConnection}
\title{Athena S3 implementation of dbplyr backend functions}
\usage{
db_save_query.AthenaConnection(
  con,
  sql,
  name,
  file_type = c("NULL", "csv", "tsv", "parquet", "json", "orc"),
  s3_location = NULL,
  partition = NULL,
  compress = TRUE,
  ...
)

db_explain.AthenaConnection(con, sql, ...)

db_query_fields.AthenaConnection(con, sql, ...)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{sql}{SQL code to be sent to AWS Athena}

\item{name}{Table name if left default noctua will use default from 'dplyr''s \code{compute} function.}

\item{file_type}{What file type to store data.frame on s3, noctua currently supports ["NULL","csv", "tsv", "parquet", "json", "orc"]. 
\code{"NULL"} will let Athena set the file_type for you.}

\item{s3_location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/")}

\item{partition}{Partition Athena table, requires to be a partitioned variable from previous table.}

\item{compress}{Compress Athena table, currently can only compress ["parquet", "orc"] \href{https://docs.aws.amazon.com/athena/latest/ug/create-table-as.html}{AWS Athena CTAS}}

\item{...}{other parameters, currently not implemented}
}
\value{
\describe{
\item{db_save_query}{Returns table name}
\item{db_explain}{Raises an \code{error} as AWS Athena does not support \code{EXPLAIN} queries \href{https://docs.aws.amazon.com/athena/latest/ug/other-notable-limitations.html}{Athena Limitations}}
\item{db_query_fields}{Returns sql query column names}
}
}
\description{
These functions are used to build the different types of SQL queries. 
The AWS Athena implementation give extra parameters to allow access the to standard DBI Athena methods. They also
utilise AWS Glue to speed up sql query execution.
}
