% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/addRates.R
\name{addRates}
\alias{addRates}
\title{Visualizes the TPR and FPR on the RBP curve.}
\usage{
addRates(obj, plot.values = TRUE, thresh = obj$prev, col = "black")
}
\arguments{
\item{obj}{[\code{\link{RBPObj}}]\cr
Data container for RBP curve.}

\item{plot.values}{[\code{logical(1)}]\cr
Whether the values of the corresponding measure should be added to the plot?
Default is \code{FALSE}.}

\item{thresh}{[\code{numeric(1)}]\cr
Threshold that is used to compute the true positve and false positive rate.
Default is prevalence.}

\item{col}{[\code{character(1)} | \code{numeric(1)}]\cr
A specification for the plotting color.}
}
\value{
[\code{invisible(NULL)}].
}
\description{
For a given threshold \code{tresh}, the true positive rate (TPR)
and the false positive rate (FPR) can be visually assessed by the RBP curve
by the intersection of the RBP curve with the horizontal lines at
\code{-thresh} and \code{1 - thresh}, respectively.
}

