% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_model.R
\name{model}
\alias{model}
\title{model object constructor.}
\usage{
model(
  fname = "Config_Model.txt",
  ID = "Linear",
  nX = 1,
  nY = 1,
  par = list(parameter("Xeffect", 1, prior.dist = "FlatPrior")),
  xtra = xtraModelInfo()
)
}
\arguments{
\item{fname}{Character, configuration file name.}

\item{ID}{Character, model ID. Type 'getCatalogue()' for available models.}

\item{nX}{Integer, number of input variables.}

\item{nY}{Integer, number of output variables.}

\item{par}{list of parameter objects, parameters of the model.}

\item{xtra}{xtraModelInfo object.}
}
\value{
An object of class 'model'.
}
\description{
Creates a new instance of a 'model' object
}
\examples{
# defaut linear regression model Y=aX+b
mod <- model()
# BaRatin model for a single-control rating curve Y=a(X-b)^c
mod <- model(ID='BaRatin',nX=1,nY=1,
             par=list(parameter('a',10,prior.dist='LogNormal',prior.par=c(log(10),0.1)),
                      parameter('b',-1,prior.dist='Gaussian',prior.par=c(-1,1)),
                      parameter('c',5/3,prior.dist='Gaussian',prior.par=c(5/3,0.05))),
             xtra=xtraModelInfo(object=matrix(1,nrow=1,ncol=1)))
}
