% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est.R
\name{glm.nreg}
\alias{glm.nreg}
\title{Non-regularied M-estimation for fitting generalized linear models}
\usage{
glm.nreg(y, x, iw = NULL, loss = "cal", init = NULL)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} response vector.}

\item{x}{An \eqn{n} x \eqn{p} matix of covariates, excluding a constant.}

\item{iw}{An \eqn{n} x \eqn{1} weight vector.}

\item{loss}{A loss function used, which can be specified as "gaus" for continuous responses, or "ml", "cal", or "bal" for binary responses.}

\item{init}{A \eqn{(p+1)} x \eqn{1} vector of initial values (the intercept and coefficients).}
}
\value{
\item{coef}{The \eqn{(p+1)} x \eqn{1} vector of estimated intercept and coefficients.}
\item{fit}{The \eqn{n} x \eqn{1} vector of fitted values.}
\item{conv}{Logical; 1 if loss="gaus" for continuous responses or convergence is obtained within 1000 iterations by \code{glm} with loss="ml" or \code{trust} with loss="cal" or "bal" for binary responses.}
}
\description{
This function implements non-regularizd M-estimation for fitting generalized linear models with continuous or binary responses, including maximum likelihood, 
calibrated estimation, and covariate-balancing estimation in the latter case of fitting propensity score models.
}
\details{
Least squares estimation is implemented by calling \code{lm} for continuous responses (\code{loss}="gaus"). For binary responses, 
maximum likelihood estimation (\code{loss}="ml") is implemented by calling \code{glm}. Calibrated estimation (\code{loss}="cal") is implemented by 
using a trust-region algorithm in the R package \pkg{trust} to minimize the calibration loss, i.e., (8) in Tan (2017). 
Covariate-balancing estimation (\code{loss}="bal") in Imai and Ratkovic (2014) is implemented by using \pkg{trust} to minimize (38) in Tan (2017).
}
\examples{
data(simu.data)
n <- dim(simu.data)[1]
p <- dim(simu.data)[2]-2

y <- simu.data[,1]
tr <- simu.data[,2]
x <- simu.data[,2+1:p]
x <- scale(x)

# include only 10 covariates
x2 <- x[,1:10]

ps.ml <- glm.nreg(y=tr, x=x2, loss="ml")
check.ml <- mn.ipw(x2, tr, ps.ml$fit)
check.ml

ps.cal <- glm.nreg(y=tr, x=x2, loss="cal")
check.cal <- mn.ipw(x2, tr, ps.cal$fit)
check.cal  # should be numerically 0

ps.bal <- glm.nreg(y=tr, x=x2, loss="bal")
check.bal <- mn.ipw(x2, tr, ps.bal$fit)
check.bal

}
\references{
Imai, K. and Ratkovic, M. (2014) Covariate balancing propensity score, \emph{Journal of the Royal Statistical Society}, Ser. B, 76, 243-263.

Tan, Z. (2017) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, arXiv:1710.08074.
}
