% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{modify_nouns}
\alias{modify_nouns}
\title{Modify nouns in labels}
\usage{
modify_nouns(
  labels,
  new_nouns,
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = FALSE
)
}
\arguments{
\item{labels}{The row and column labels in which the nouns will be modified.}

\item{new_nouns}{The new nouns to be set in \code{labels}.
Must be same length as \code{labels}.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{labels}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{The notation type to be used when extracting prepositions.
Default is \code{RCLabels::notations_list}, meaning that
the notation is inferred using \code{infer_notation()}.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \code{RCLabels::notations_list},
the default value of \code{FALSE} means that
\code{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\code{RCLabels::from_notation}.}
}
\value{
A character vector of same length as labels
with nouns modified to be \code{new_nouns}.
}
\description{
This function modifies the nouns of row and column labels.
The length of \code{new_nouns} must be the same as the length of \code{labels}.
}
\examples{
labels <- c("a [of b in c]", "d [of e in USA]")
modify_nouns(labels, c("a_plus", "g"))
}
