% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrid.R
\name{regrid}
\alias{regrid}
\title{Project the values of a \code{\link{cmip5data}} object onto a new grid}
\usage{
regrid(orgVar, projLat, projLon, orgArea = NULL, projArea = NULL,
  projectionMatrix = NULL, verbose = FALSE)
}
\arguments{
\item{orgVar}{A \code{\link{cmip5data}} object to be regridded}

\item{projLat}{TODO}

\item{projLon}{TODO}

\item{orgArea}{TODO}

\item{projArea}{A \code{\link{cmip5data}} object or list with lat (latitude) and log (longitude) matricies
of the projection grid}

\item{projectionMatrix}{TODO}

\item{verbose}{logical. Print info as we go?}
}
\value{
A \code{\link{cmip5data}} object, whose \code{val} is the area-weighted regrided
variable passed in \code{orgVar} parameter. A \code{projectionMatrix} field is also added
recording projection matrix used in regridding; this can be reused for later variables with the same regridding.
}
\description{
Project the values of a \code{\link{cmip5data}} object onto a new grid
}
\details{
This function calculates the projection matrix to shift one global grid to a second.
The relative contribution of an old grid to the new grid is calculated via an area weighting scheme
where the area of a grid cell is assumed to be proportional to the degree area of that cell and
neighboring cells are assumed to have the same area to degree ratios. This will NOT hold in large grids.
Nor is the area weighting scheme appropreate for all variable types and grid shifts. Use with caution.
}
\seealso{
\code{\link{getProjectionMatrix}}
}

