% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-venn.R
\name{plotVennDE}
\alias{plotVennDE}
\title{Plot venndiagram from multiple DE Analysis results}
\usage{
plotVennDE(
  DEResults,
  pThreshold = 0.05,
  useFDR = TRUE,
  stat = "logFC",
  statThreshold = 0
)
}
\arguments{
\item{DEResults}{A list of data frames with the results of DE analysis.}

\item{pThreshold}{The p-value threshold to determine if a gene is differentially expressed.}

\item{useFDR}{Use the FDR adjusted p-value instead of the raw p-value.}

\item{stat}{The additional statistis column to use for filtering differentially expressed genes.}

\item{statThreshold}{The absolute value of the statistic threshold to use for filtering differentially expressed genes.
Default is 0, which means no filtering.}
}
\value{
A ggplot2 object.
}
\description{
Plot a venndiagram from multiple DE Analysis results.
}
\examples{
\donttest{
library(RCPA)
library(SummarizedExperiment)

affyDEExperiment <- loadData("affyDEExperiment")
agilDEExperiment <- loadData("agilDEExperiment")
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")

DEResults <- list(
    "Affymetrix - GSE5281" = rowData(affyDEExperiment),
    "Agilent - GSE61196"   = rowData(agilDEExperiment),
    "RNASeq - GSE153873"   = rowData(RNASeqDEExperiment)
)
DEResultUps <- lapply(DEResults, function(df) df[!is.na(df$logFC) & df$logFC > 0, ])
DEResultDowns <- lapply(DEResults, function(df) df[!is.na(df$logFC) & df$logFC < 0, ])
if (require("ggvenn", quietly = TRUE)){
RCPA::plotVennDE(DEResults) + ggplot2::ggtitle("All DE Genes")
RCPA::plotVennDE(DEResultUps) + ggplot2::ggtitle("Up-regulated DE Genes")
RCPA::plotVennDE(DEResultDowns) + ggplot2::ggtitle("Down-regulated DE Genes")
}

}
}
