% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compmeansC.r
\name{compmeansC}
\alias{compmeansC}
\title{Mean comparison analysis function, makes controlled comparisons, generates plots, performs ANOVA}
\usage{
compmeansC(dv, iv, w, z, data, digits = 2, compact = FALSE, ivlabs, zlabs,
  anova = FALSE, printC = FALSE, plot = TRUE, main, xlab, ylab, ylim,
  plot.ci = FALSE, z.palette, legend.title)
}
\arguments{
\item{dv}{Dependent variable, should be in dataset$var form unless dataset specified in optional data argument.}

\item{iv}{Independent variable, should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable (optional), must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{z}{(Optional) Control variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains dv, iv (and w) variables (optional).}

\item{digits}{(Optional) The number of decimal places reported in result (defaults to 2).}

\item{compact}{(Optional) Do you want compact version of controlled mean comparison table with N and Std. Dev. values omitted? Default is FALSE. Compact display only available for controlled comparisons.}

\item{ivlabs}{(Optional) A vector of names for the independent variable's values (to abbreviate the mean comparison table's row labels and iv labels on plots)}

\item{zlabs}{(Optional) A vector of names for the control variable's values (to abbreviate a controlled mean comparison table's column labels and z variable's labels on plots)}

\item{anova}{(Optional) Do you want to conduct analysis of variance (ANOVA)? Default is FALSE.}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{plot}{(Optional) Do you want a plot of the means? Default is TRUE (makes a bar plot). Additional options:
\itemize{
\item "line" to make a line plot
\item "bar", TRUE, or T for bar plot (default plot)
\item "points" to show means as points without connecting lines,
\item FALSE or F to suppress plot.
}}

\item{main}{(Optional) Main label for plot, if missing, default main title generated.}

\item{xlab}{(Optional) x-axis label for plot, if missing, default label generated using iv name.}

\item{ylab}{(Optional) y-axis label for plot, if missing, default label generated using dv name.}

\item{ylim}{(Optional) Range of y-axis values on plot.}

\item{plot.ci}{(Optional) Do you want vertical 95 percent confidence intervals added to line plot of means? Default is FALSE. Only works when \code{plot="line"} or \code{plot="points"}}

\item{z.palette}{(Optional) For bar and line charts with control variables (z), the name of HCL color palette to use. Default is "LightGrays". See \code{grDevices::hcl.pals} for palette names and more information. Also see \url{https://developer.r-project.org/Blog/public/2019/04/01/hcl-based-color-palettes-in-grdevices/} to view color palettes.}

\item{legend.title}{(Optional) Customize title of legend on plot used for controlling comparisons.}
}
\value{
Returns a mean comparison table as a matrix of values.
}
\description{
Mean comparison analysis, options for weighted observations and control variable. Also supports several plotting options for basic mean comparisons and controlled mean comparisons. Can conduct single and two-factor analysis of variance (ANOVA) to test differences among multiple means.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapters 4, 5, 7, 10.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp.85-97, 150-156. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=4}{R Tutorials & Resources for Making Comparisons}, \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=5}{Graphing Relationships and Describing Patterns}, \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=7}{Making Controlled Comparisons}, and \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=10}{Chi-Square Test and Analysis of Variance}, compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
  library(RCPA3)
   
  \donttest{
  # basic usage: dv and iv, variables are vectors
  compmeansC(dv=nes$ft.rep, iv=nes$partyid7)
  compmeansC(dv=nes$ft.rep, iv=nes$partyid7, w=nes$wt, plot=TRUE)
  
  # basic usage: data argument used
  compmeansC(dv=infant.mortality, iv=region, data=world, plot=FALSE)
  
  # with weights and z variable
  compmeansC(dv=nes$ft.rep, iv=nes$partyid7, w=nes$wt, z=nes$gender, plot="line")
  compmeansC(dv=nes$ft.gay, iv=nes$gender, z=nes$partyid3, compact=TRUE, plot=TRUE)
  }
}
