% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{update_g}
\alias{update_g}
\title{Function that estimates group membership.}
\usage{
update_g(
  robust,
  Y,
  X,
  beta_est,
  g,
  factor_group,
  lambda,
  comfactor,
  S,
  k,
  kg,
  vars_est,
  method_estimate_factors,
  method_estimate_beta,
  verbose = FALSE
)
}
\arguments{
\item{robust}{robust or classical estimation of group membership}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{factor_group}{estimated group specific factors}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{vars_est}{number of variables that will be included in the algorithm and have their coefficient estimated. This is usually equal to the number of observable variables.}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{verbose}{when TRUE, it prints messages}
}
\value{
Returns a list. The first element contains a vector with the estimated group membership for all time series. The second element contains the values
which were used to determine the group membership. The third element is only relevant if method_estimate_factors is set to "cz" (non-default) and
contains the group membership before moving some of the time series to class zero.
}
\description{
Function that estimates group membership.
}
\examples{
\donttest{
X <- X_dgp3
Y <- Y_dgp3
# Set estimations for group factors and its loadings, and group membership to the true value
lambda_group <- lambda_group_true_dgp3
factor_group <- factor_group_true_dgp3
g_true <- g_true_dgp3 # true values of group membership
g <- g_true # estimated values of group membership; set in this example to be equal to true values
# There are no common factors to be estimated  ->  use placeholder with values set to zero
lambda <- matrix(0, nrow = 1, ncol = 300)
comfactor <- matrix(0, nrow = 1, ncol = 30)
# Choose how coefficients of the observable are estimated
beta_est <- estimate_beta(
  robust = TRUE, Y, X, NA, g, lambda_group, factor_group,
  lambda, comfactor,
  S = 3, k = 0, kg = c(3, 3, 3),
  vars_est = 3
)[[1]]
g_new <- update_g(
  robust = TRUE, Y, X, beta_est, g,
  factor_group, lambda, comfactor,
  S = 3,
  k = 0,
  kg = c(3, 3, 3),
  vars_est = 3,
  "macro", "individual"
)[[1]]
}
}
