% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_VCsquared}
\alias{calculate_VCsquared}
\title{Calculates VC², to determine the stability of the found number of groups and factors over the subsamples.}
\usage{
calculate_VCsquared(
  rcj,
  rc,
  C_candidates,
  indices_subset,
  Smax,
  limit_est_groups = 20
)
}
\arguments{
\item{rcj}{dataframe containg the numer of groupfactors for all candidate C's and all subsamples}

\item{rc}{dataframe containg the numer of common factors for all candidate C's and all subsamples}

\item{C_candidates}{candidates for C (parameter in PIC)}

\item{indices_subset}{all indices of the subsets}

\item{Smax}{maximum allowed number of estimated groups}

\item{limit_est_groups}{maximum allowed number of groups that can be estimated}
}
\value{
numeric vector with the VC2-value for each candidate C
}
\description{
VC² depends on C (this is the scale parameter in PIC). When VC² is equal to zero, the found number of groups and factors
are the same over the subsamples.
}
\examples{
rcj <- data.frame(X1 = rep("3_3_3", 5), X2 = rep("3_2_1", 5))
rc <- data.frame(X1 = rep(1, 5), X2 = rep(0, 5))
calculate_VCsquared(rcj, rc, 1:5, 0:1, 3)
}
