% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_errors_virtual_groups}
\alias{calculate_errors_virtual_groups}
\title{Helpfunction for update_g(). Calculates the errors for one of the possible groups time series can be placed in.}
\usage{
calculate_errors_virtual_groups(
  group,
  LF,
  virtual_grouped_factor_structure,
  NN,
  TT,
  k,
  kg,
  vars_est,
  method_estimate_beta,
  Y,
  X,
  beta_est,
  g
)
}
\arguments{
\item{group}{group}

\item{LF}{NxT-matrix of the common factorstructure}

\item{virtual_grouped_factor_structure}{list with length the number of groups; every element of the list contains NxT-matrix}

\item{NN}{number of time series}

\item{TT}{length of time series}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{vars_est}{number of variables that will be included in the algorithm and have their coefficient estimated. This is usually equal to the number of observable variables.}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{dataframe with the observed variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}
}
\value{
NxT matrix with the errorterms (=Y minus the estimated factorstructure(s) and minus X*beta)
}
\description{
During the updating of group membership, the errorterm is used as the objective function to estimate the group.
}
