% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHLine.R
\name{addLine}
\alias{addLine}
\alias{plotHLine}
\title{Plot a "homogeneous" line to a plot.}
\usage{
addLine(l, ...)

plotHLine(l, ...)
}
\arguments{
\item{l}{A \eqn{3 \times 1} vector of the homogeneous representation of a line.}

\item{\dots}{\link{graphical parameters} such as \code{col}, \code{lty} and  \code{lwd}.}
}
\description{
Add a homogeneous line to a plot. The line parameters must be in homogeneous coordinates, e.g. \eqn{(a,b,c)}.
}
\examples{
# two points in homogeneous coordinates
p1 <- c(3,1,1)
p2 <- c(0,2,1)

# homogeneous line joining p1 and p2
l_12 <- join(p1,p2)
l_12

# plot
plot(0,0,type="n", xlim=c(-2,5),ylim=c(-2,5),asp=1)
points(t(p1))
points(t(p2))
addLine(l_12,col="red",lwd=2)
}
