% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-plots.R
\name{bottleneck.plot}
\alias{bottleneck.plot}
\title{Bottleneck Plot}
\usage{
bottleneck.plot(rds.data, outcome.variable, est.func = RDS.II.estimates,
  as.factor = FALSE, n.eval.points = 25, ...)
}
\arguments{
\item{rds.data}{An rds.data.frame.}

\item{outcome.variable}{A character vector of outcome variables.}

\item{est.func}{A function taking rds.data and outcome.variable as parameters and
returning an rds.weighted.estimate object.}

\item{as.factor}{Convert all outcome variables to factors}

\item{n.eval.points}{number of evaluation points to calculate the estimates at}

\item{...}{additional parameters for est.func.}
}
\description{
Bottleneck Plot
}
\examples{
data(fauxmadrona)
bottleneck.plot(fauxmadrona,"disease")
}
\references{
Krista J. Gile, Lisa G. Johnston, Matthew J. Salganik \emph{Diagnostics for Respondent-driven Sampling} eprint arXiv:1209.6254, 2012
}
