/*
 *========================================================================
 * $Id: dieharder.c 127 2004-11-20 18:17:55Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  run_rgb_operm()
 *========================================================================
 */

#include "dieharder.h"

void run_rgb_operm()
{

 /*
  * Declare the results struct.
  */
 Test **rgb_operm_test;
 uint ntmin,ntmax;

 /*
  * Set any GLOBAL data used by the test.  rgb_operm_k is the value
  * assigned by -n ntuple (max).  We'll start, at least, by just running
  * the test for one value of rgb_operm_k but will leave in a harness
  * loop that can run a whole range.
  *
  * Note that we have to do this BEFORE creating the test (in the latter
  * case because dtest.nkps will depend on the value of rgb_operm_k.
  */

 if(ntuple){
   ntmax = ntuple;
   ntmin = ntuple;
 } else {
   /*
    * Default will be to test 2 through 5 bit permutation.
    * Currently, though, we're just doing 2.
    */
   ntmin = 2;
   ntmax = 2;
 }
 if(all == YES) ntmin = 1;

 /* printf("Setting ntmin = %d ntmax = %d\n",ntmin,ntmax); */
 for(rgb_operm_k = ntmin;rgb_operm_k<=ntmax;rgb_operm_k++){
   /*
    * First we create the test (to set some values displayed in test header
    * correctly).
    */
   rgb_operm_test = create_test(&rgb_operm_dtest,tsamples,psamples,&rgb_operm);

   /*
    * Show the standard test header for this test.
    */
   show_test_header(&rgb_operm_dtest,rgb_operm_test);
   /*
    * Append the following SPECIAL line
    */
   printf("# Testing distribution of overlapping permutations of %d integers.\n",rgb_operm_k);

   /*
    * Set any GLOBAL data used by the test.  Then call the test itself
    * This fills in the results in the Test struct.
    */
   std_test(&rgb_operm_dtest,rgb_operm_test);

   /*
    * This almost certainly belongs in the show_test_results section,
    * possibly with additional conditionals rejecting test results involving
    * rewinds, period.
    */
   if(strncmp("file_input",gsl_rng_name(rng),10) == 0){
     printf("# %u rands were used in this test\n",file_input_get_rtot(rng));
     printf("# The file %s was rewound %u times\n",gsl_rng_name(rng),file_input_get_rewind_cnt(rng));
   }

   /*
    * Show standard test results, for all statistics generated by a single run.
    */
   show_test_results(&rgb_operm_dtest,rgb_operm_test);

   /*
    * Free any GLOBAL data used by the test.
    */
   destroy_test(&rgb_operm_dtest,rgb_operm_test);

 }

}
