% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skimr.R
\name{add_skimr_metadata}
\alias{add_skimr_metadata}
\title{Add \link[skimr]{skimr} metrics to a supertibble's metadata}
\usage{
add_skimr_metadata(supertbl)
}
\arguments{
\item{supertbl}{a supertibble generated using \code{read_redcap()}}
}
\value{
A supertibble with \link[skimr]{skimr} metadata metrics
}
\description{
Add default \link[skimr]{skim} metrics to the \code{redcap_data} list elements of
a supertibble output from \code{read_readcap}.
}
\details{
For more information on the default metrics provided, check the
\link[skimr]{get_default_skimmer_names}
documentation.
}
\examples{
superheroes_supertbl

add_skimr_metadata(superheroes_supertbl)

\dontrun{
redcap_uri <- Sys.getenv("REDCAP_URI")
token <- Sys.getenv("REDCAP_TOKEN")

supertbl <- read_redcap(redcap_uri, token)
add_skimr_metadata(supertbl)
}

}
