% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_redcap_xlsx}
\alias{write_redcap_xlsx}
\title{Write Supertibbles to XLSX}
\usage{
write_redcap_xlsx(
  supertbl,
  file,
  add_labelled_column_headers = NULL,
  use_labels_for_sheet_names = TRUE,
  include_toc_sheet = TRUE,
  include_metadata_sheet = TRUE,
  table_style = "tableStyleLight8",
  column_width = "auto",
  recode_logical = TRUE,
  na_replace = "",
  overwrite = FALSE
)
}
\arguments{
\item{supertbl}{A supertibble generated using \code{read_redcap()}.}

\item{file}{The name of the file to which the output will be written.}

\item{add_labelled_column_headers}{If \code{TRUE}, the first row of each sheet will contain variable labels,
with variable names in the second row. If \code{FALSE}, variable names will be in the first row.
The default value, \code{NULL}, tries to determine if \code{supertbl} contains variable labels and,
if present, includes them in the first row. The \code{labelled} package must be installed
if \code{add_labelled_column_headers} is \code{TRUE}.}

\item{use_labels_for_sheet_names}{If \code{FALSE}, sheet names will come from the REDCap instrument names.
If \code{TRUE}, sheet names will come from instrument labels. The default is \code{TRUE}.}

\item{include_toc_sheet}{If \code{TRUE}, the first sheet in the XLSX output will be a table of contents,
providing information about each data tibble in the workbook. The default is \code{TRUE}.}

\item{include_metadata_sheet}{If \code{TRUE}, the final sheet in the XLSX output will contain metadata
about each variable, combining the content of \code{supertbl$redcap_metadata}. The default is \code{TRUE}.}

\item{table_style}{Any Excel table style name or "none". For more details, see
the
\href{https://ycphs.github.io/openxlsx/articles/Formatting.html#use-of-pre-defined-table-styles}{"formatting" vignette}
of the \code{openxlsx} package. The default is "tableStyleLight8".}

\item{column_width}{Sets the width of columns throughout the workbook.
The default is "auto", but you can specify a numeric value.}

\item{recode_logical}{If \code{TRUE}, fields with "yesno" field type are recoded to "yes"/"no" and fields
with a "checkbox" field type are recoded to "Checked"/"Unchecked". The default is \code{TRUE}.}

\item{na_replace}{The value used to replace \code{NA} values in \code{supertbl}. The default is "".}

\item{overwrite}{If \code{FALSE}, will not overwrite \code{file} when it exists. The default is \code{FALSE}.}
}
\value{
An \code{openxlsx2} workbook object, invisibly
}
\description{
Transform a supertibble into an XLSX file, with each REDCap data tibble in a separate sheet.
}
\examples{
\dontrun{
redcap_uri <- Sys.getenv("REDCAP_URI")
token <- Sys.getenv("REDCAP_TOKEN")

supertbl <- read_redcap(redcap_uri, token)

supertbl \%>\%
  write_redcap_xlsx(file = "supertibble.xlsx")

# Add variable labels

library(labelled)

supertbl \%>\%
  make_labelled() \%>\%
  write_redcap_xlsx(file = "supertibble.xlsx", add_labelled_column_headers = TRUE)
}

}
