#' Annotation for the Example Data set
#' 
#' A mapping between junctions and probe sets for the example data set in this package.
#' 
#' @name AnnotationExampleData
#' 
#' @usage data(AnnotationExampleData)
#' 
#' @format An object of class \code{"data.frame"}.
#' @examples
#' data(AnnotationExampleData)
NULL

#' DABG p-values 
#' 
#' The DABG p-values for the junctions and probe sets of the example data set in this package.
#' 
#' @name Example_DAGC
#'
#' @usage data(Example_DAGC)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(Example_DAGC)
NULL

#' Probe ID's for a set of probe sets
#' 
#' A mapping between the probe ID's and the unit ID's for the DABG file..
#' 
#' @name Example_probeset_probesfile
#' 
#' @docType data
#'
#' @usage data(Example_probeset_probesfile)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(Example_probeset_probesfile)
NULL

#' An example data set
#' 
#' An example data set containing the expression values of the probe sets of two genes.
#' 
#' @name ExampleData
#' 
#' @docType data
#'
#' @usage data(ExampleData)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(ExampleData)
NULL

#' Exon level data
#' 
#' An example data set containing the summarized expression values on the exon level of the probe sets of one gene.
#' 
#' @name ExampleExonLevel
#' 
#' @docType data
#'
#' @usage data(ExampleExonLevel)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(ExampleExonLevel)
NULL

#' FIRMA Output
#' 
#' An example data set containing the obtained FIRMA values for two genes.
#' 
#' @name ExampleFirmaOutput
#' 
#' @docType data
#'
#' @usage data(ExampleFirmaOutput)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(ExampleFirmaOutput)
NULL

#' Gene level data
#' 
#' An example data set containing the summarized expression value of one gene.
#' 
#' @name ExampleGeneLevel
#' 
#' @docType data
#'
#' @usage data(ExampleGeneLevel)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @keywords datasets
#' @examples
#' data(ExampleGeneLevel)
NULL