/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.CloneableRandomStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class MT19937
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MULT_MATRIX_A = new int[]{0, -1727483681};
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private int[] state;
    private int state_i;
    private CloneableRandomStream seedRng;

    private void fillSeed() {
        this.state_i = 624;
        for (int i = 0; i < 624; ++i) {
            this.state[i] = (int)(this.seedRng.nextDouble() * 4.294967296E9);
        }
    }

    public MT19937(CloneableRandomStream cloneableRandomStream) {
        this.seedRng = cloneableRandomStream;
        this.name = null;
        this.state = new int[624];
        this.resetStartStream();
    }

    public MT19937(CloneableRandomStream cloneableRandomStream, String string) {
        this(cloneableRandomStream);
        this.name = string;
    }

    public MT19937 clone() {
        MT19937 mT19937 = null;
        mT19937 = (MT19937)super.clone();
        mT19937.state = new int[624];
        for (int i = 0; i < 624; ++i) {
            mT19937.state[i] = this.state[i];
        }
        mT19937.seedRng = this.seedRng.clone();
        return mT19937;
    }

    public void resetStartStream() {
        this.seedRng.resetStartStream();
        this.fillSeed();
    }

    public void resetStartSubstream() {
        this.seedRng.resetStartSubstream();
        this.fillSeed();
    }

    public void resetNextSubstream() {
        this.seedRng.resetNextSubstream();
        this.fillSeed();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("This MT19937 ");
        } else {
            stringBuffer.append(this.name + " ");
        }
        stringBuffer.append("has a " + this.seedRng.getClass() + " for its seed.\n");
        stringBuffer.append("State = [");
        for (int i = 0; i < 623; ++i) {
            stringBuffer.append(this.state[i] + ",");
        }
        stringBuffer.append(this.state[623] + "]. ");
        stringBuffer.append("State index = " + this.state_i);
        return stringBuffer.toString();
    }

    protected double nextValue() {
        int n;
        if (this.state_i >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.state[n2] & Integer.MIN_VALUE | this.state[n2 + 1] & Integer.MAX_VALUE;
                this.state[n2] = this.state[n2 + 397] ^ n >>> 1 ^ MULT_MATRIX_A[n & 1];
            }
            while (n2 < 623) {
                n = this.state[n2] & Integer.MIN_VALUE | this.state[n2 + 1] & Integer.MAX_VALUE;
                this.state[n2] = this.state[n2 + -227] ^ n >>> 1 ^ MULT_MATRIX_A[n & 1];
                ++n2;
            }
            n = this.state[623] & Integer.MIN_VALUE | this.state[0] & Integer.MAX_VALUE;
            this.state[623] = this.state[396] ^ n >>> 1 ^ MULT_MATRIX_A[n & 1];
            this.state_i = 0;
        }
        n = this.state[this.state_i++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        long l = (n ^= n >>> 18) <= 0 ? (long)n + 0x100000000L : (long)n;
        return (double)l * 2.3283064359965952E-10;
    }
}

