% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvFPM.R
\name{cvFPM}
\alias{cvFPM}
\title{Cross-Validation Optimization of the Floating Percentile Model}
\usage{
cvFPM(
  data,
  paramList,
  FN_crit = seq(0.1, 0.9, 0.05),
  k = 5,
  seed = NULL,
  plot = TRUE,
  tryStop = 10,
  simplify = TRUE,
  which = c(1, 2),
  ...
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{FN_crit}{numeric vector of values between 0 and 1 indicating false negative threshold for floating percentile model benchmark selection (default = \code{seq(0.1, 0.9, 0.05)})}

\item{k}{numeric value >1 indicating the number of k-folds to include in cross-validation (default = \code{5})}

\item{seed}{random seed to set for reproducible results (default = \code{NULL}, i.e., no seed)}

\item{plot}{whether to plot the output of \code{cvFPM} (default = \code{TRUE})}

\item{tryStop}{specifies the number of times the cross-validation algorithm will try to run before ending (see Details; default = \code{10})}

\item{simplify}{logical; whether to return just the optimized \code{FN_crit} value or more detailed diagnostic information}

\item{which}{numeric or character indicating which type of plot to generate (see Details; default = \code{c(1, 2)})}

\item{...}{additional arguments passed to \code{chemSig} and \code{FPM}}
}
\value{
list with 1 or 3 objects (depending on whether or not \code{simplify = TRUE});
these include 1) \code{optim_FN}, the optimized \code{FN_crit} value; 2) \code{CV_OR}, the detailed breakdown of overall
reliability values for each \code{FN_crit} value; and 3) \code{CV_FPM}, floating percentile model benchark statistics based on
all cross-validation runs for each \code{FN_crit}
}
\description{
Use k-folds cross-validation method to calculate parameter inputs that optimize benchmark performance
while attempting to account for out-of-sample error
}
\details{
\code{cvFPM} allows users to "tune" \code{FN_crit} argument in \code{FPM}. This is achieved by splitting the empirical dataset into "test" and "training" subsets,
calculating benchmarks for the training set, and then calculating the benchmarks' prediction errors using the test set.
This process is repeated several times (the number depending on the size of \code{k} relative to the sample size), and the results are summarized statistically.
Lastly, this process is repeated for each \code{FN_crit} value specified by the user, resulting in comparable
statistics for each \code{FN_crit}. The output in the console indicates which \code{FN_crit} value resulted in the consistently optimal benchmarks
(meaning highest overall reliability or most balanced errors).
By setting \code{plot = TRUE} (the default), the outcome of cross-validation can be visualized over the range of \code{FN_crit} values considered. Visualizing the results
can inform the user about variability in the cross-validation process, ranges of potentially reasonable \code{FN_crit} values, etc.

\code{cvFPM} does not currently support optimization of the \code{alpha} parameter of \code{FPM};
\code{optimFPM} allows the user to optimize \code{alpha} but only using the empirical data (not through cross-validation).

Errors may be encountered by setting the value of \code{k} too high or too low, resulting in an inability of \code{cvFPM}
to generate meaningful subsets for testing and floating percentile model calculations. Groups for subsetting are roughly
evenly applied within the cross-validation method, so it is reasonable to expect that \code{ceiling(nrow(data)/k)} is the number of
samples in any given test subset, with \code{nrow(data) - ceiling(nrow(data)/k)} being the size of the training subset. If a large number
of samples still generates an error, consider increasing the \code{tryStop} value and rerunning \code{cvFPM}. The easiest way
to avoid this type of error is to keep \code{k} low relative to \code{nrow(data)} (bearing in mind that \code{k} must be >1).

The \code{which} argument can be used to specify which of the two plots should be generated when \code{plot = TRUE}. These plots include
the optimization results based on the overall reliability metric or the balanced rate of false positives and false negatives. Inputs
to \code{which} are, by default, \code{c(1, 2)}, but flexible character inputs also can be used, for example \code{which = "OR"} or \code{which = "balanced"}.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
cvFPM(data = h.tristate, paramList = paramList, FN_crit = seq(0.1, 0.9, 0.1), which = "OR")
}
\seealso{
chemSig, FPM, seq
}
