/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;

public class FitnessProportionalSelection
extends Selection
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int noOfIndividualsToSelect = 1;
    private boolean invert;
    private boolean unique;

    public FitnessProportionalSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on single objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] original) {
        int i = 0;
        while (i < original.length) {
            if (original[i] == null) {
                throw new NoSuchIndividualException();
            }
            ++i;
        }
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.noOfIndividualsToSelect)};
        if (original[0].size() > 0) {
            int i2;
            Individual[] origin = original[0].toArray();
            if (this.unique && this.noOfIndividualsToSelect >= original[0].size()) {
                int i3 = 0;
                while (i3 < origin.length) {
                    result[0].addIndividual(origin[i3]);
                    ++i3;
                }
            }
            FitnessFunction fitness = this.graph.getSchedule().getFitnessFunction();
            double sum = 0.0;
            double[] fvalue = new double[origin.length];
            double[] limit = new double[origin.length];
            int i4 = 0;
            while (i4 < origin.length) {
                fvalue[i4] = ((SingleObjectiveFitnessFunction)fitness).evaluate(origin[i4], original[0]);
                sum += fvalue[i4];
                ++i4;
            }
            if (this.invert) {
                double max = fvalue[0];
                i2 = 0;
                while (i2 < origin.length) {
                    if (fvalue[i2] > max) {
                        max = fvalue[i2];
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < origin.length) {
                    fvalue[i2] = 1.0 + max - fvalue[i2];
                    sum += fvalue[i2];
                    ++i2;
                }
                limit[0] = 1.0 + max - fvalue[0] / sum;
                i2 = 1;
                while (i2 < origin.length) {
                    limit[i2] = limit[i2 - 1] + (1.0 + max - fvalue[i2] / sum);
                    ++i2;
                }
            } else {
                i4 = 0;
                while (i4 < origin.length) {
                    fvalue[i4] = ((SingleObjectiveFitnessFunction)fitness).evaluate(origin[i4], original[0]);
                    sum += fvalue[i4];
                    ++i4;
                }
                limit[0] = fvalue[0] / sum;
                i4 = 1;
                while (i4 < origin.length) {
                    limit[i4] = limit[i4 - 1] + fvalue[i4] / sum;
                    ++i4;
                }
            }
            RandomElement randomGen = this.graph.getSchedule().getRandomElement();
            boolean[] selected = new boolean[origin.length];
            i2 = 0;
            while (i2 < this.noOfIndividualsToSelect) {
                int select;
                do {
                    double number = randomGen.uniform(0.0, 1.0);
                    select = this.doSelect(limit, number);
                } while (this.unique && selected[select]);
                selected[select] = true;
                result[0].addIndividual(origin[select]);
                ++i2;
            }
        }
        return result;
    }

    private int doSelect(double[] limit, double number) {
        int reference = 0;
        int first = 0;
        int last = limit.length - 1;
        while (last - first > 1) {
            reference = (int)((double)(last + first) / 2.0);
            if (limit[reference] > number) {
                last = reference;
            }
            if (limit[reference] < number) {
                first = reference;
            }
            if (limit[reference] != number) continue;
            return reference;
        }
        if (limit[first] > number) {
            return first;
        }
        return last;
    }

    public Integer getPropertyNoOfIndividualsToSelect() {
        return new Integer(this.noOfIndividualsToSelect);
    }

    public void setPropertyNoOfIndividualsToSelect(Integer noOfIndividualsToSelect) {
        this.noOfIndividualsToSelect = noOfIndividualsToSelect;
        if (this.noOfIndividualsToSelect <= 0) {
            this.noOfIndividualsToSelect = 1;
        }
    }

    public String getShortDescriptionForNoOfIndividualsToSelect() {
        return "Selected individuals";
    }

    public String getLongDescriptionForNoOfIndividualsToSelect() {
        return "The number of individuals to be selected.";
    }

    public Boolean getPropertyInvert() {
        return new Boolean(this.invert);
    }

    public void setPropertyInvert(Boolean invert) {
        this.invert = invert;
    }

    public String getLongDescriptionForInvert() {
        return "When 'invert' is enabled, an individual is chosen with probability (1+max-f(x))/f(population).";
    }

    public Boolean getPropertyUnique() {
        return new Boolean(this.unique);
    }

    public void setPropertyUnique(Boolean unique) {
        this.unique = unique;
    }

    public String getLongDescriptionForUnique() {
        return "If enabled, an individual is only returned once.";
    }

    public String getName() {
        return "Fitness Proportional Selection";
    }

    public String getDescription() {
        return "Selects individuals using fitness proportional selection.\r\nNormally, an individual is chosen with probability f(x)/f(population). You may, however, specify options changing this behavior.";
    }
}

